/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreml;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Marshaler(value=ValuedEnum.AsMachineSizedSIntMarshaler.class)
@Library(value="CoreML")
public enum MLModelError implements NSErrorCode
{
    Generic(0L),
    FeatureType(1L),
    IO(3L),
    CustomLayer(4L),
    CustomModel(5L),
    Update(6L),
    Parameters(7L),
    ModelDecryptionKeyFetch(8L),
    ModelDecryption(9L),
    ModelCollection(10L);

    private final long n;

    @GlobalValue(symbol="MLModelErrorDomain", optional=true)
    public static native String getClassDomain();

    private MLModelError(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static MLModelError valueOf(long n) {
        for (MLModelError v : MLModelError.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + MLModelError.class.getName());
    }

    static {
        Bro.bind(MLModelError.class);
        Bro.bind(NSErrorWrap.class);
    }

    @StronglyLinked
    public static class NSErrorWrap
    extends NSError {
        protected NSErrorWrap(NSObject.SkipInit skipInit) {
            super(skipInit);
        }

        @Override
        public NSErrorCode getErrorCode() {
            try {
                return MLModelError.valueOf(this.getCode());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String getClassDomain() {
            return MLModelError.getClassDomain();
        }
    }
}

