/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreservices;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coreservices.CFHTTPMessage;
import org.robovm.apple.coreservices.CFProxyType;
import org.robovm.apple.foundation.NSURL;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CFNetwork")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CFProxy
extends CFDictionaryWrapper {
    CFProxy(CFDictionary data) {
        super(data);
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public CFProxyType getType() {
        if (this.has(Keys.Type())) {
            CFString val = this.get(Keys.Type(), CFString.class);
            return CFProxyType.valueOf(val);
        }
        return null;
    }

    public String getHost() {
        if (this.has(Keys.HostName())) {
            CFString val = this.get(Keys.HostName(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public int getPort() {
        if (this.has(Keys.PortNumber())) {
            CFNumber val = this.get(Keys.PortNumber(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public NSURL getAutoConfigurationURL() {
        if (this.has(Keys.AutoConfigurationURL())) {
            NSURL val = this.get(Keys.AutoConfigurationURL(), NSURL.class);
            return val;
        }
        return null;
    }

    public String getAutoConfigurationJavaScript() {
        if (this.has(Keys.AutoConfigurationJavaScript())) {
            CFString val = this.get(Keys.AutoConfigurationJavaScript(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public String getUsername() {
        if (this.has(Keys.Username())) {
            CFString val = this.get(Keys.Username(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public String getPassword() {
        if (this.has(Keys.Password())) {
            CFString val = this.get(Keys.Password(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CFHTTPMessage getAutoConfigurationHTTPResponse() {
        if (this.has(Keys.AutoConfigurationHTTPResponse())) {
            CFHTTPMessage val = this.get(Keys.AutoConfigurationHTTPResponse(), CFHTTPMessage.class);
            return val;
        }
        return null;
    }

    @Library(value="CFNetwork")
    public static class Keys {
        @GlobalValue(symbol="kCFProxyTypeKey", optional=true)
        public static native CFString Type();

        @GlobalValue(symbol="kCFProxyHostNameKey", optional=true)
        public static native CFString HostName();

        @GlobalValue(symbol="kCFProxyPortNumberKey", optional=true)
        public static native CFString PortNumber();

        @GlobalValue(symbol="kCFProxyAutoConfigurationURLKey", optional=true)
        public static native CFString AutoConfigurationURL();

        @GlobalValue(symbol="kCFProxyAutoConfigurationJavaScriptKey", optional=true)
        public static native CFString AutoConfigurationJavaScript();

        @GlobalValue(symbol="kCFProxyUsernameKey", optional=true)
        public static native CFString Username();

        @GlobalValue(symbol="kCFProxyPasswordKey", optional=true)
        public static native CFString Password();

        @GlobalValue(symbol="kCFProxyAutoConfigurationHTTPResponseKey", optional=true)
        public static native CFString AutoConfigurationHTTPResponse();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CFProxy> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CFProxy> list = new ArrayList<CFProxy>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CFProxy(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CFProxy> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CFProxy i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CFProxy toObject(Class<CFProxy> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CFProxy(o);
        }

        @MarshalsPointer
        public static long toNative(CFProxy o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

