/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFComparisonResult;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coretext.CTFontCollectionOptions;
import org.robovm.apple.coretext.CTFontDescriptor;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreText")
public class CTFontCollection
extends CFType {
    private static AtomicLong refconId = new AtomicLong();
    private static LongMap<SortCallback> sortCallbacks = new LongMap();
    private static final Method cbSort;

    protected CTFontCollection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static CFComparisonResult cbSort(CTFontDescriptor first, CTFontDescriptor second, @Pointer long refcon) {
        SortCallback callback = null;
        LongMap<SortCallback> longMap = sortCallbacks;
        synchronized (longMap) {
            callback = (SortCallback)sortCallbacks.get(refcon);
        }
        return callback.sort(first, second);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CTFontDescriptor> getMatchingFontDescriptorsSorted(SortCallback sortCallback) {
        long refconId = CTFontCollection.refconId.getAndIncrement();
        LongMap<SortCallback> longMap = sortCallbacks;
        synchronized (longMap) {
            sortCallbacks.put(refconId, (Object)sortCallback);
        }
        return this.getMatchingFontDescriptorsSorted(new FunctionPtr(cbSort), refconId);
    }

    @Bridge(symbol="CTFontCollectionGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CTFontCollectionCreateFromAvailableFonts", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFontCollection createFromAvailableFonts(CTFontCollectionOptions var0);

    @Bridge(symbol="CTFontCollectionCreateWithFontDescriptors", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFontCollection create(@Marshaler(value=CTFontDescriptor.AsListMarshaler.class) List<CTFontDescriptor> var0, CTFontCollectionOptions var1);

    @Bridge(symbol="CTFontCollectionCreateCopyWithFontDescriptors", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CTFontCollection createCopy(@Marshaler(value=CTFontDescriptor.AsListMarshaler.class) List<CTFontDescriptor> var1, CTFontCollectionOptions var2);

    @Bridge(symbol="CTFontCollectionCreateMatchingFontDescriptors", optional=true)
    @Marshaler(value=CTFontDescriptor.AsListMarshaler.class)
    public native List<CTFontDescriptor> getMatchingFontDescriptors();

    @Bridge(symbol="CTFontCollectionCreateMatchingFontDescriptorsSortedWithCallback", optional=true)
    @Marshaler(value=CTFontDescriptor.AsListMarshaler.class)
    protected native List<CTFontDescriptor> getMatchingFontDescriptorsSorted(FunctionPtr var1, @Pointer long var2);

    @Bridge(symbol="CTFontCollectionCreateMatchingFontDescriptorsWithOptions", optional=true)
    public native CFArray createMatchingFontDescriptorsWithOptions(NSDictionary var1);

    static {
        try {
            cbSort = CTFontCollection.class.getDeclaredMethod("cbSort", CTFontDescriptor.class, CTFontDescriptor.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CTFontCollection.class);
    }

    public static interface SortCallback {
        public CFComparisonResult sort(CTFontDescriptor var1, CTFontDescriptor var2);
    }

    public static class CTFontCollectionPtr
    extends Ptr<CTFontCollection, CTFontCollectionPtr> {
    }
}

