/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSFastEnumeration;
import org.robovm.apple.foundation.NSIndexSet;
import org.robovm.apple.foundation.NSKeyValueObservingOptions;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSPropertyList;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCObject;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="Foundation")
@NativeClass
public class NSArray<T extends NSObject>
extends NSObject
implements NSFastEnumeration,
NSPropertyList,
List<T> {
    private AbstractList<T> adapter = this.createAdapter();

    public NSArray() {
    }

    protected NSArray(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSArray(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSArray(Collection<T> c) {
        super(null);
        if (c == null) {
            throw new NullPointerException("c");
        }
        if (c instanceof NSArray) {
            this.initObject(this.init((NSArray)c));
        } else {
            ObjCObject[] objects = c.toArray(new ObjCObject[c.size()]);
            this.initWithObjects(objects);
        }
    }

    public NSArray(T ... objects) {
        super(null);
        if (objects == null) {
            throw new NullPointerException("objects");
        }
        this.initWithObjects((ObjCObject[])objects);
    }

    @Property(selector="count")
    @MachineSizedUInt
    protected native long getCount();

    @Property(selector="firstObject")
    public native T first();

    @Property(selector="lastObject")
    public native T last();

    @Property(selector="sortedArrayHint")
    public native NSData getSortedArrayHint();

    protected static void checkNull(Object o) {
        if (o == null) {
            throw new NullPointerException("null values are not allowed in NSArray. Use NSNull instead.");
        }
    }

    private void initWithObjects(ObjCObject[] objects) {
        VoidPtr.VoidPtrPtr ptr = null;
        if (objects.length > 0) {
            ptr = (VoidPtr.VoidPtrPtr)Struct.allocate(VoidPtr.VoidPtrPtr.class, (int)objects.length);
            for (int i = 0; i < objects.length; ++i) {
                NSArray.checkNull(objects[i]);
                ptr.set(objects[i].getHandle());
                ptr = (VoidPtr.VoidPtrPtr)ptr.next();
            }
            ptr = (VoidPtr.VoidPtrPtr)ptr.previous((long)objects.length);
        }
        this.initObject(this.init(ptr != null ? ptr.getHandle() : 0L, objects.length));
    }

    protected AbstractList<T> createAdapter() {
        return new ListAdapter(this);
    }

    @Override
    protected void afterMarshaled(int flags) {
        if (this.adapter == null) {
            this.adapter = this.createAdapter();
        }
        super.afterMarshaled(flags);
    }

    @Override
    public void add(int index, T element) {
        this.adapter.add(index, element);
    }

    @Override
    public boolean add(T e) {
        return this.adapter.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.adapter.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.adapter.addAll(index, c);
    }

    @Override
    public void clear() {
        this.adapter.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.adapter.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.adapter.containsAll(c);
    }

    @Override
    public T get(int index) {
        return (T)((NSObject)this.adapter.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.adapter.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.adapter.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.adapter.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.adapter.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.adapter.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.adapter.listIterator(index);
    }

    @Override
    public T remove(int index) {
        return (T)((NSObject)this.adapter.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        return this.adapter.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.adapter.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.adapter.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        return (T)((NSObject)this.adapter.set(index, element));
    }

    @Override
    public int size() {
        return this.adapter.size();
    }

    @Override
    public NSArray<T> subList(int start, int end) {
        if (start >= 0 && end <= this.size()) {
            if (start <= end) {
                return this.getSubarray(new NSRange(start, end - start));
            }
            throw new IllegalArgumentException();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object[] toArray() {
        return this.adapter.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.adapter.toArray(a);
    }

    public boolean getBoolean(int index) {
        Object val = this.get(index);
        if (val instanceof NSNumber) {
            return ((NSNumber)val).booleanValue();
        }
        this.wrongType(index, val.getClass());
        return false;
    }

    public byte getByte(int index) {
        Object val = this.get(index);
        if (val instanceof NSNumber) {
            return ((NSNumber)val).byteValue();
        }
        this.wrongType(index, val.getClass());
        return 0;
    }

    public short getByte(short index) {
        Object val = this.get(index);
        if (val instanceof NSNumber) {
            return ((NSNumber)val).shortValue();
        }
        this.wrongType(index, val.getClass());
        return 0;
    }

    public int getInt(int index) {
        Object val = this.get(index);
        if (val instanceof NSNumber) {
            return ((NSNumber)val).intValue();
        }
        this.wrongType(index, val.getClass());
        return 0;
    }

    public long getLong(int index) {
        Object val = this.get(index);
        if (val instanceof NSNumber) {
            return ((NSNumber)val).longValue();
        }
        this.wrongType(index, val.getClass());
        return 0L;
    }

    public float getFloat(int index) {
        Object val = this.get(index);
        if (val instanceof NSNumber) {
            return ((NSNumber)val).floatValue();
        }
        this.wrongType(index, val.getClass());
        return 0.0f;
    }

    public double getDouble(int index) {
        Object val = this.get(index);
        if (val instanceof NSNumber) {
            return ((NSNumber)val).doubleValue();
        }
        this.wrongType(index, val.getClass());
        return 0.0;
    }

    public String getString(int index) {
        Object val = this.get(index);
        if (val instanceof NSString) {
            return ((NSObject)val).toString();
        }
        this.wrongType(index, val.getClass());
        return null;
    }

    private void wrongType(int index, Class<?> type) {
        throw new ClassCastException("Wrong type at index " + index + ": " + type);
    }

    @Override
    public boolean add(boolean value) {
        throw new UnsupportedOperationException("NSArray is immutable");
    }

    @Override
    public void add(int index, boolean value) {
        throw new UnsupportedOperationException("NSArray is immutable");
    }

    @Override
    public boolean add(Number value) {
        throw new UnsupportedOperationException("NSArray is immutable");
    }

    @Override
    public void add(int index, Number value) {
        throw new UnsupportedOperationException("NSArray is immutable");
    }

    @Override
    public boolean add(String value) {
        throw new UnsupportedOperationException("NSArray is immutable");
    }

    @Override
    public void add(int index, String value) {
        throw new UnsupportedOperationException("NSArray is immutable");
    }

    @Override
    public Object set(int index, boolean element) {
        throw new UnsupportedOperationException("NSArray is immutable");
    }

    @Override
    public Object set(int index, Number element) {
        throw new UnsupportedOperationException("NSArray is immutable");
    }

    @Override
    public Object set(int index, String element) {
        throw new UnsupportedOperationException("NSArray is immutable");
    }

    public int indexOf(boolean element) {
        return this.indexOf(NSNumber.valueOf(element));
    }

    public int indexOf(Number element) {
        return this.indexOf(NSNumber.valueOf(element));
    }

    public int indexOf(String element) {
        return this.indexOf(new NSString(element));
    }

    public boolean remove(boolean element) {
        throw new UnsupportedOperationException("NSArray is immutable");
    }

    public boolean remove(Number element) {
        throw new UnsupportedOperationException("NSArray is immutable");
    }

    public boolean remove(String element) {
        throw new UnsupportedOperationException("NSArray is immutable");
    }

    public static NSArray<?> read(File file) {
        return NSArray.readFile(file.getAbsolutePath());
    }

    public void write(File file, boolean atomically) {
        this.writeFile(file.getAbsolutePath(), atomically);
    }

    public List<String> asStringList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.size() == 0) {
            return list;
        }
        if (!(this.get(0) instanceof NSString)) {
            throw new UnsupportedOperationException("items must be of type NSString");
        }
        for (NSObject str : this) {
            list.add(str.toString());
        }
        return list;
    }

    public static NSArray<NSString> fromStrings(String ... strings) {
        int length = strings.length;
        NSObject[] nsStrings = new NSString[length];
        for (int i = 0; i < length; ++i) {
            nsStrings[i] = new NSString(strings[i]);
        }
        return new NSArray(nsStrings);
    }

    public static NSArray<NSString> fromStrings(Collection<String> strings) {
        NSObject[] nsStrings = new NSString[strings.size()];
        int i = 0;
        for (String s : strings) {
            nsStrings[i] = new NSString(s);
            ++i;
        }
        return new NSArray(nsStrings);
    }

    public static NSArray<NSNumber> fromNumbers(Number ... numbers) {
        int length = numbers.length;
        NSObject[] nsNumbers = new NSNumber[length];
        for (int i = 0; i < length; ++i) {
            nsNumbers[i] = NSNumber.valueOf(numbers[i]);
        }
        return new NSArray(nsNumbers);
    }

    public static NSArray<NSNumber> fromNumbers(Collection<Number> numbers) {
        NSObject[] nsNumbers = new NSNumber[numbers.size()];
        int i = 0;
        for (Number n : numbers) {
            nsNumbers[i] = NSNumber.valueOf(n);
            ++i;
        }
        return new NSArray(nsNumbers);
    }

    @Method(selector="objectAtIndex:")
    protected native T getObjectAt(@MachineSizedUInt long var1);

    @Method(selector="initWithObjects:count:")
    @Pointer
    protected native long init(@Pointer long var1, @MachineSizedUInt long var3);

    @Method(selector="containsObject:")
    protected native boolean containsObject(T var1);

    @Method(selector="indexOfObject:")
    @MachineSizedUInt
    protected native long indexOfObject(T var1);

    @Method(selector="subarrayWithRange:")
    protected native NSArray<T> getSubarray(@ByVal NSRange var1);

    @Method(selector="initWithArray:")
    @Pointer
    protected native long init(NSArray<T> var1);

    @Deprecated
    @Method(selector="writeToFile:atomically:")
    protected native boolean writeFile(String var1, boolean var2);

    @Deprecated
    @Method(selector="writeToURL:atomically:")
    public native boolean write(NSURL var1, boolean var2);

    @Deprecated
    @Method(selector="arrayWithContentsOfFile:")
    protected static native NSArray<?> readFile(String var0);

    @Deprecated
    @Method(selector="arrayWithContentsOfURL:")
    public static native NSArray<?> read(NSURL var0);

    @Method(selector="addObserver:toObjectsAtIndexes:forKeyPath:options:context:")
    public native void addObserver(NSObject var1, NSIndexSet var2, String var3, NSKeyValueObservingOptions var4, VoidPtr var5);

    @Method(selector="removeObserver:fromObjectsAtIndexes:forKeyPath:context:")
    public native void removeObserver(NSObject var1, NSIndexSet var2, String var3, VoidPtr var4);

    static {
        ObjCRuntime.bind(NSArray.class);
    }

    static class ListAdapter<U extends NSObject>
    extends AbstractList<U> {
        protected final NSArray<U> array;

        ListAdapter(NSArray<U> array) {
            this.array = array;
        }

        @Override
        public U get(int index) {
            this.checkIndex(index);
            return this.array.getObjectAt(index);
        }

        protected void checkIndex(int index) {
            int size = (int)this.array.getCount();
            if (index < 0 || index >= size) {
                throw new IndexOutOfBoundsException("index = " + index + ", size = " + size);
            }
        }

        @Override
        public int size() {
            return (int)this.array.getCount();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof NSObject) {
                return this.array.containsObject((NSObject)o);
            }
            return false;
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof NSObject) {
                return (int)this.array.indexOfObject((NSObject)o);
            }
            return -1;
        }
    }

    public static class AsStringListMarshaler {
        @MarshalsPointer
        public static List<String> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            return o.asStringList();
        }

        @MarshalsPointer
        public static long toNative(List<String> l, long flags) {
            if (l == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(NSArray.fromStrings(l), flags);
        }
    }

    public static class AsDoubleListMarshaler {
        @MarshalsPointer
        public static List<Double> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<Double> list = new ArrayList<Double>();
            for (NSNumber n : o) {
                list.add(n.doubleValue());
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<Double> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSNumber> array = new NSMutableArray<NSNumber>();
            for (Double i : l) {
                array.add(NSNumber.valueOf(i));
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class AsIntegerListMarshaler {
        @MarshalsPointer
        public static List<Integer> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (NSNumber n : o) {
                list.add(n.intValue());
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<Integer> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSNumber> array = new NSMutableArray<NSNumber>();
            for (Integer i : l) {
                array.add(NSNumber.valueOf(i));
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<?> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            return (NSArray)NSObject.Marshaler.toObject(cls, handle, flags);
        }

        @MarshalsPointer
        public static long toNative(List<?> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSArray o = null;
            o = l instanceof NSArray ? (NSArray)l : new NSArray((Collection<?>)l);
            return NSObject.Marshaler.toNative(o, flags);
        }
    }

    public static class NSArrayPtr<T extends NSObject>
    extends Ptr<NSArray<T>, NSArrayPtr<T>> {
    }
}

