/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSFileAttribute;
import org.robovm.apple.foundation.NSFileProtection;
import org.robovm.apple.foundation.NSFileType;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Foundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class NSFileAttributes
extends NSDictionaryWrapper {
    NSFileAttributes(NSDictionary data) {
        super(data);
    }

    public NSFileAttributes() {
    }

    public boolean has(NSFileAttribute key) {
        return this.data.containsKey(key.value());
    }

    public NSObject get(NSFileAttribute key) {
        if (this.has(key)) {
            return this.data.get(key.value());
        }
        return null;
    }

    public NSFileAttributes set(NSFileAttribute key, NSObject value) {
        this.data.put((NSObject)key.value(), value);
        return this;
    }

    public NSFileType getType() {
        if (this.has(NSFileAttribute.Type)) {
            NSString val = (NSString)this.get(NSFileAttribute.Type);
            return NSFileType.valueOf(val);
        }
        return null;
    }

    public NSFileAttributes setType(NSFileType type) {
        this.set(NSFileAttribute.Type, (NSObject)type.value());
        return this;
    }

    public long getSize() {
        if (this.has(NSFileAttribute.Size)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.Size);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setSize(long size) {
        this.set(NSFileAttribute.Size, NSNumber.valueOf(size));
        return this;
    }

    public NSDate getModificationDate() {
        if (this.has(NSFileAttribute.ModificationDate)) {
            NSDate val = (NSDate)this.get(NSFileAttribute.ModificationDate);
            return val;
        }
        return null;
    }

    public NSFileAttributes setModificationDate(NSDate modificationDate) {
        this.set(NSFileAttribute.ModificationDate, modificationDate);
        return this;
    }

    public long getReferenceCount() {
        if (this.has(NSFileAttribute.ReferenceCount)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.ReferenceCount);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setReferenceCount(long referenceCount) {
        this.set(NSFileAttribute.ReferenceCount, NSNumber.valueOf(referenceCount));
        return this;
    }

    public long getDeviceIdentifier() {
        if (this.has(NSFileAttribute.DeviceIdentifier)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.DeviceIdentifier);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setDeviceIdentifier(long deviceIdentifier) {
        this.set(NSFileAttribute.DeviceIdentifier, NSNumber.valueOf(deviceIdentifier));
        return this;
    }

    public String getOwnerAccountName() {
        if (this.has(NSFileAttribute.OwnerAccountName)) {
            NSString val = (NSString)this.get(NSFileAttribute.OwnerAccountName);
            return val.toString();
        }
        return null;
    }

    public NSFileAttributes setOwnerAccountName(String ownerAccountName) {
        this.set(NSFileAttribute.OwnerAccountName, new NSString(ownerAccountName));
        return this;
    }

    public String getGroupOwnerAccountName() {
        if (this.has(NSFileAttribute.GroupOwnerAccountName)) {
            NSString val = (NSString)this.get(NSFileAttribute.GroupOwnerAccountName);
            return val.toString();
        }
        return null;
    }

    public NSFileAttributes setGroupOwnerAccountName(String groupOwnerAccountName) {
        this.set(NSFileAttribute.GroupOwnerAccountName, new NSString(groupOwnerAccountName));
        return this;
    }

    public short getPosixPermissions() {
        if (this.has(NSFileAttribute.PosixPermissions)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.PosixPermissions);
            return val.shortValue();
        }
        return 0;
    }

    public NSFileAttributes setPosixPermissions(short posixPermissions) {
        this.set(NSFileAttribute.PosixPermissions, NSNumber.valueOf(posixPermissions));
        return this;
    }

    public long getSystemFileNumber() {
        if (this.has(NSFileAttribute.SystemFileNumber)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.SystemFileNumber);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setSystemFileNumber(long systemFileNumber) {
        this.set(NSFileAttribute.SystemFileNumber, NSNumber.valueOf(systemFileNumber));
        return this;
    }

    public boolean isExtensionHidden() {
        if (this.has(NSFileAttribute.ExtensionHidden)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.ExtensionHidden);
            return val.booleanValue();
        }
        return false;
    }

    public NSFileAttributes setExtensionHidden(boolean extensionHidden) {
        this.set(NSFileAttribute.ExtensionHidden, NSNumber.valueOf(extensionHidden));
        return this;
    }

    public long getHFSCreatorCode() {
        if (this.has(NSFileAttribute.HFSCreatorCode)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.HFSCreatorCode);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setHFSCreatorCode(long hFSCreatorCode) {
        this.set(NSFileAttribute.HFSCreatorCode, NSNumber.valueOf(hFSCreatorCode));
        return this;
    }

    public long getHFSTypeCode() {
        if (this.has(NSFileAttribute.HFSTypeCode)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.HFSTypeCode);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setHFSTypeCode(long hFSTypeCode) {
        this.set(NSFileAttribute.HFSTypeCode, NSNumber.valueOf(hFSTypeCode));
        return this;
    }

    public boolean isImmutable() {
        if (this.has(NSFileAttribute.Immutable)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.Immutable);
            return val.booleanValue();
        }
        return false;
    }

    public NSFileAttributes setImmutable(boolean immutable) {
        this.set(NSFileAttribute.Immutable, NSNumber.valueOf(immutable));
        return this;
    }

    public boolean appendsOnly() {
        if (this.has(NSFileAttribute.AppendOnly)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.AppendOnly);
            return val.booleanValue();
        }
        return false;
    }

    public NSFileAttributes setAppendsOnly(boolean appendsOnly) {
        this.set(NSFileAttribute.AppendOnly, NSNumber.valueOf(appendsOnly));
        return this;
    }

    public NSDate getCreationDate() {
        if (this.has(NSFileAttribute.CreationDate)) {
            NSDate val = (NSDate)this.get(NSFileAttribute.CreationDate);
            return val;
        }
        return null;
    }

    public NSFileAttributes setCreationDate(NSDate creationDate) {
        this.set(NSFileAttribute.CreationDate, creationDate);
        return this;
    }

    public long getOwnerAccountID() {
        if (this.has(NSFileAttribute.OwnerAccountID)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.OwnerAccountID);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setOwnerAccountID(long ownerAccountID) {
        this.set(NSFileAttribute.OwnerAccountID, NSNumber.valueOf(ownerAccountID));
        return this;
    }

    public long getGroupOwnerAccountID() {
        if (this.has(NSFileAttribute.GroupOwnerAccountID)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.GroupOwnerAccountID);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setGroupOwnerAccountID(long groupOwnerAccountID) {
        this.set(NSFileAttribute.GroupOwnerAccountID, NSNumber.valueOf(groupOwnerAccountID));
        return this;
    }

    public boolean isBusy() {
        if (this.has(NSFileAttribute.Busy)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.Busy);
            return val.booleanValue();
        }
        return false;
    }

    public NSFileAttributes setBusy(boolean busy) {
        this.set(NSFileAttribute.Busy, NSNumber.valueOf(busy));
        return this;
    }

    public NSFileProtection getProtection() {
        if (this.has(NSFileAttribute.ProtectionKey)) {
            NSString val = (NSString)this.get(NSFileAttribute.ProtectionKey);
            return NSFileProtection.valueOf(val);
        }
        return null;
    }

    public NSFileAttributes setProtection(NSFileProtection protection) {
        this.set(NSFileAttribute.ProtectionKey, (NSObject)protection.value());
        return this;
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<NSFileAttributes> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<NSFileAttributes> list = new ArrayList<NSFileAttributes>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new NSFileAttributes((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<NSFileAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (NSFileAttributes i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSFileAttributes toObject(Class<NSFileAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSFileAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(NSFileAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

