/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSMetadataItemAttribute;
import org.robovm.apple.foundation.NSMetadataItemDownloadingStatus;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Foundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class NSMetadataItemAttributes
extends NSDictionaryWrapper {
    NSMetadataItemAttributes(NSDictionary data) {
        super(data);
    }

    public boolean has(NSMetadataItemAttribute key) {
        return this.data.containsKey(key.value());
    }

    public NSObject get(NSMetadataItemAttribute key) {
        if (this.has(key)) {
            return this.data.get(key.value());
        }
        return null;
    }

    public String getFSName() {
        if (this.has(NSMetadataItemAttribute.FSName)) {
            NSString val = (NSString)this.get(NSMetadataItemAttribute.FSName);
            return val.toString();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.has(NSMetadataItemAttribute.DisplayName)) {
            NSString val = (NSString)this.get(NSMetadataItemAttribute.DisplayName);
            return val.toString();
        }
        return null;
    }

    public NSURL getURL() {
        if (this.has(NSMetadataItemAttribute.URL)) {
            NSURL val = (NSURL)this.get(NSMetadataItemAttribute.URL);
            return val;
        }
        return null;
    }

    public String getPath() {
        if (this.has(NSMetadataItemAttribute.Path)) {
            NSString val = (NSString)this.get(NSMetadataItemAttribute.Path);
            return val.toString();
        }
        return null;
    }

    public long getFSSize() {
        if (this.has(NSMetadataItemAttribute.FSSize)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.FSSize);
            return val.longValue();
        }
        return 0L;
    }

    public NSDate getFSCreationDate() {
        if (this.has(NSMetadataItemAttribute.FSCreationDate)) {
            NSDate val = (NSDate)this.get(NSMetadataItemAttribute.FSCreationDate);
            return val;
        }
        return null;
    }

    public NSDate getFSContentChangeDate() {
        if (this.has(NSMetadataItemAttribute.FSContentChangeDate)) {
            NSDate val = (NSDate)this.get(NSMetadataItemAttribute.FSContentChangeDate);
            return val;
        }
        return null;
    }

    public String getContentType() {
        if (this.has(NSMetadataItemAttribute.ContentType)) {
            NSString val = (NSString)this.get(NSMetadataItemAttribute.ContentType);
            return val.toString();
        }
        return null;
    }

    public List<String> getContentTypeTree() {
        if (this.has(NSMetadataItemAttribute.ContentTypeTree)) {
            NSArray val = (NSArray)this.get(NSMetadataItemAttribute.ContentTypeTree);
            return val.asStringList();
        }
        return null;
    }

    public boolean isUbiquitous() {
        if (this.has(NSMetadataItemAttribute.IsUbiquitous)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.IsUbiquitous);
            return val.booleanValue();
        }
        return false;
    }

    public boolean hasUnresolvedConflicts() {
        if (this.has(NSMetadataItemAttribute.HasUnresolvedConflicts)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.HasUnresolvedConflicts);
            return val.booleanValue();
        }
        return false;
    }

    @Deprecated
    public boolean isDownloaded() {
        if (this.has(NSMetadataItemAttribute.IsDownloaded)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.IsDownloaded);
            return val.booleanValue();
        }
        return false;
    }

    public NSMetadataItemDownloadingStatus getDownloadingStatus() {
        if (this.has(NSMetadataItemAttribute.DownloadingStatus)) {
            NSString val = (NSString)this.get(NSMetadataItemAttribute.DownloadingStatus);
            return NSMetadataItemDownloadingStatus.valueOf(val);
        }
        return null;
    }

    public boolean isDownloading() {
        if (this.has(NSMetadataItemAttribute.IsDownloading)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.IsDownloading);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isUploaded() {
        if (this.has(NSMetadataItemAttribute.IsUploaded)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.IsUploaded);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isUploading() {
        if (this.has(NSMetadataItemAttribute.IsUploading)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.IsUploading);
            return val.booleanValue();
        }
        return false;
    }

    public double getPercentDownloaded() {
        if (this.has(NSMetadataItemAttribute.PercentDownloaded)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.PercentDownloaded);
            return val.doubleValue();
        }
        return 0.0;
    }

    public double getPercentUploaded() {
        if (this.has(NSMetadataItemAttribute.PercentUploaded)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.PercentUploaded);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSError getDownloadingError() {
        if (this.has(NSMetadataItemAttribute.DownloadingError)) {
            NSError val = (NSError)this.get(NSMetadataItemAttribute.DownloadingError);
            return val;
        }
        return null;
    }

    public NSError getUploadingError() {
        if (this.has(NSMetadataItemAttribute.UploadingError)) {
            NSError val = (NSError)this.get(NSMetadataItemAttribute.UploadingError);
            return val;
        }
        return null;
    }

    public boolean isDownloadRequested() {
        if (this.has(NSMetadataItemAttribute.DownloadRequested)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.DownloadRequested);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isExternalDocument() {
        if (this.has(NSMetadataItemAttribute.IsExternalDocument)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.IsExternalDocument);
            return val.booleanValue();
        }
        return false;
    }

    public String getContainerDisplayName() {
        if (this.has(NSMetadataItemAttribute.ContainerDisplayName)) {
            NSString val = (NSString)this.get(NSMetadataItemAttribute.ContainerDisplayName);
            return val.toString();
        }
        return null;
    }

    public NSURL getURLInLocalContainer() {
        if (this.has(NSMetadataItemAttribute.URLInLocalContainer)) {
            NSURL val = (NSURL)this.get(NSMetadataItemAttribute.URLInLocalContainer);
            return val;
        }
        return null;
    }

    public double getContentRelevance() {
        if (this.has(NSMetadataItemAttribute.ContentRelevance)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.ContentRelevance);
            return val.doubleValue();
        }
        return 0.0;
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<NSMetadataItemAttributes> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<NSMetadataItemAttributes> list = new ArrayList<NSMetadataItemAttributes>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new NSMetadataItemAttributes((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<NSMetadataItemAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (NSMetadataItemAttributes i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSMetadataItemAttributes toObject(Class<NSMetadataItemAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSMetadataItemAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(NSMetadataItemAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

