/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.NSCharacterSet;
import org.robovm.apple.foundation.NSDecimal;
import org.robovm.apple.foundation.NSLocale;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.MachineSizedSIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSScanner
extends NSObject {
    public NSScanner() {
    }

    protected NSScanner(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSScanner(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithString:")
    public NSScanner(String string) {
        super(null);
        this.initObject(this.init(string));
    }

    @Property(selector="string")
    public native String getString();

    @Property(selector="scanLocation")
    @MachineSizedUInt
    public native long getScanLocation();

    @Property(selector="setScanLocation:")
    public native void setScanLocation(@MachineSizedUInt long var1);

    @Property(selector="charactersToBeSkipped")
    public native NSCharacterSet getCharactersToBeSkipped();

    @Property(selector="setCharactersToBeSkipped:")
    public native void setCharactersToBeSkipped(NSCharacterSet var1);

    @Property(selector="caseSensitive")
    public native boolean isCaseSensitive();

    @Property(selector="setCaseSensitive:")
    public native void setCaseSensitive(boolean var1);

    @Property(selector="locale")
    public native NSLocale getLocale();

    @Property(selector="setLocale:")
    public native void setLocale(NSLocale var1);

    @Property(selector="isAtEnd")
    public native boolean isAtEnd();

    public int scanInt() {
        IntPtr ptr = new IntPtr();
        if (!this.scanInt(ptr)) {
            return 0;
        }
        return ptr.get();
    }

    @MachineSizedSInt
    public double scanInteger() {
        MachineSizedSIntPtr ptr = new MachineSizedSIntPtr();
        if (!this.scanInteger(ptr)) {
            return 0.0;
        }
        return ptr.get();
    }

    public long scanLong() {
        LongPtr ptr = new LongPtr();
        if (!this.scanLongLong(ptr)) {
            return 0L;
        }
        return ptr.get();
    }

    public long scanUnsignedLong() {
        LongPtr ptr = new LongPtr();
        if (!this.scanUnsignedLongLong(ptr)) {
            return 0L;
        }
        return ptr.get();
    }

    public float scanFloat() {
        FloatPtr ptr = new FloatPtr();
        if (!this.scanFloat(ptr)) {
            return 0.0f;
        }
        return ptr.get();
    }

    public double scanDouble() {
        DoublePtr ptr = new DoublePtr();
        if (!this.scanDouble(ptr)) {
            return 0.0;
        }
        return ptr.get();
    }

    public int scanHexInt() {
        IntPtr ptr = new IntPtr();
        if (!this.scanHexInt(ptr)) {
            return 0;
        }
        return ptr.get();
    }

    public long scanHexLong() {
        LongPtr ptr = new LongPtr();
        if (!this.scanHexLongLong(ptr)) {
            return 0L;
        }
        return ptr.get();
    }

    public float scanHexFloat() {
        FloatPtr ptr = new FloatPtr();
        if (!this.scanHexFloat(ptr)) {
            return 0.0f;
        }
        return ptr.get();
    }

    public double scanHexDouble() {
        DoublePtr ptr = new DoublePtr();
        if (!this.scanHexDouble(ptr)) {
            return 0.0;
        }
        return ptr.get();
    }

    public String scanString(String string) {
        NSString.NSStringPtr ptr = new NSString.NSStringPtr();
        if (!this.scanString(string, ptr)) {
            return null;
        }
        return ((NSString)ptr.get()).toString();
    }

    public String scanCharacters(NSCharacterSet set) {
        NSString.NSStringPtr ptr = new NSString.NSStringPtr();
        if (!this.scanCharactersFromSet(set, ptr)) {
            return null;
        }
        return ((NSString)ptr.get()).toString();
    }

    public String scanUpToString(String string) {
        NSString.NSStringPtr ptr = new NSString.NSStringPtr();
        if (!this.scanUpToString(string, ptr)) {
            return null;
        }
        return ((NSString)ptr.get()).toString();
    }

    public String scanUpToCharacters(NSCharacterSet set) {
        NSString.NSStringPtr ptr = new NSString.NSStringPtr();
        if (!this.scanUpToCharactersFromSet(set, ptr)) {
            return null;
        }
        return ((NSString)ptr.get()).toString();
    }

    public NSDecimal scanDecimal() {
        NSDecimal.NSDecimalPtr ptr = new NSDecimal.NSDecimalPtr();
        if (!this.scanDecimal(ptr)) {
            return null;
        }
        return (NSDecimal)ptr.get();
    }

    @Method(selector="initWithString:")
    @Pointer
    protected native long init(String var1);

    @Method(selector="scanInt:")
    private native boolean scanInt(IntPtr var1);

    @Method(selector="scanInteger:")
    private native boolean scanInteger(MachineSizedSIntPtr var1);

    @Method(selector="scanLongLong:")
    private native boolean scanLongLong(LongPtr var1);

    @Method(selector="scanUnsignedLongLong:")
    private native boolean scanUnsignedLongLong(LongPtr var1);

    @Method(selector="scanFloat:")
    private native boolean scanFloat(FloatPtr var1);

    @Method(selector="scanDouble:")
    private native boolean scanDouble(DoublePtr var1);

    @Method(selector="scanHexInt:")
    private native boolean scanHexInt(IntPtr var1);

    @Method(selector="scanHexLongLong:")
    private native boolean scanHexLongLong(LongPtr var1);

    @Method(selector="scanHexFloat:")
    private native boolean scanHexFloat(FloatPtr var1);

    @Method(selector="scanHexDouble:")
    private native boolean scanHexDouble(DoublePtr var1);

    @Method(selector="scanString:intoString:")
    private native boolean scanString(String var1, NSString.NSStringPtr var2);

    @Method(selector="scanCharactersFromSet:intoString:")
    private native boolean scanCharactersFromSet(NSCharacterSet var1, NSString.NSStringPtr var2);

    @Method(selector="scanUpToString:intoString:")
    private native boolean scanUpToString(String var1, NSString.NSStringPtr var2);

    @Method(selector="scanUpToCharactersFromSet:intoString:")
    private native boolean scanUpToCharactersFromSet(NSCharacterSet var1, NSString.NSStringPtr var2);

    @Method(selector="localizedScannerWithString:")
    public static native NSScanner createLocalized(String var0);

    @Method(selector="scanDecimal:")
    private native boolean scanDecimal(NSDecimal.NSDecimalPtr var1);

    static {
        ObjCRuntime.bind(NSScanner.class);
    }

    public static class NSScannerPtr
    extends Ptr<NSScanner, NSScannerPtr> {
    }
}

