/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.imageio;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGColor;
import org.robovm.apple.imageio.CGImageProperties;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="ImageIO")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CGImageDestinationProperties
extends CGImageProperties {
    CGImageDestinationProperties(CFDictionary data) {
        super(data);
    }

    public CGImageDestinationProperties() {
    }

    @Override
    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    @Override
    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    @Override
    public CGImageDestinationProperties set(CFString key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public double getLossyCompressionQuality() {
        if (this.has(Keys.LossyCompressionQuality())) {
            CFNumber val = this.get(Keys.LossyCompressionQuality(), CFNumber.class);
            return val.doubleValue();
        }
        return 1.0;
    }

    public CGImageDestinationProperties setLossyCompressionQuality(double lossyCompressionQuality) {
        this.set(Keys.LossyCompressionQuality(), CFNumber.valueOf(lossyCompressionQuality));
        return this;
    }

    public CGColor getBackgroundColor() {
        if (this.has(Keys.BackgroundColor())) {
            CGColor val = this.get(Keys.BackgroundColor(), CGColor.class);
            return val;
        }
        return null;
    }

    public CGImageDestinationProperties setBackgroundColor(CGColor backgroundColor) {
        this.set(Keys.BackgroundColor(), backgroundColor);
        return this;
    }

    public long getMaxPixelSize() {
        if (this.has(Keys.ImageMaxPixelSize())) {
            CFNumber val = this.get(Keys.ImageMaxPixelSize(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CGImageDestinationProperties setMaxPixelSize(long maxPixelSize) {
        this.set(Keys.ImageMaxPixelSize(), CFNumber.valueOf(maxPixelSize));
        return this;
    }

    public boolean embedsThumbnail() {
        if (this.has(Keys.EmbedThumbnail())) {
            CFBoolean val = this.get(Keys.EmbedThumbnail(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageDestinationProperties setEmbedsThumbnail(boolean embedsThumbnail) {
        this.set(Keys.EmbedThumbnail(), CFBoolean.valueOf(embedsThumbnail));
        return this;
    }

    @Library(value="ImageIO")
    public static class Keys {
        @GlobalValue(symbol="kCGImageDestinationLossyCompressionQuality", optional=true)
        public static native CFString LossyCompressionQuality();

        @GlobalValue(symbol="kCGImageDestinationBackgroundColor", optional=true)
        public static native CFString BackgroundColor();

        @GlobalValue(symbol="kCGImageDestinationImageMaxPixelSize", optional=true)
        public static native CFString ImageMaxPixelSize();

        @GlobalValue(symbol="kCGImageDestinationEmbedThumbnail", optional=true)
        public static native CFString EmbedThumbnail();

        @GlobalValue(symbol="kCGImageDestinationOptimizeColorForSharing", optional=true)
        public static native CFString OptimizeColorForSharing();

        @GlobalValue(symbol="kCGImageDestinationPreserveGainMap", optional=true)
        public static native CFString PreserveGainMap();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CGImageDestinationProperties> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CGImageDestinationProperties> list = new ArrayList<CGImageDestinationProperties>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CGImageDestinationProperties(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CGImageDestinationProperties> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CGImageDestinationProperties i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CGImageDestinationProperties toObject(Class<CGImageDestinationProperties> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CGImageDestinationProperties(o);
        }

        @MarshalsPointer
        public static long toNative(CGImageDestinationProperties o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

