/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mapkit;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corelocation.CLLocationCoordinate2D;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.mapkit.MKCoordinateSpan;
import org.robovm.apple.mapkit.MKDirectionsMode;
import org.robovm.apple.mapkit.MKMapCamera;
import org.robovm.apple.mapkit.MKMapType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="MapKit")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class MKLaunchOptions
extends NSDictionaryWrapper {
    MKLaunchOptions(NSDictionary data) {
        super(data);
    }

    public MKLaunchOptions() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public MKLaunchOptions set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public MKDirectionsMode getDirectionsMode() {
        if (this.has(Keys.DirectionsMode())) {
            NSString val = (NSString)this.get(Keys.DirectionsMode());
            return MKDirectionsMode.valueOf(val);
        }
        return null;
    }

    public MKLaunchOptions setDirectionsMode(MKDirectionsMode directionsMode) {
        this.set(Keys.DirectionsMode(), (NSObject)directionsMode.value());
        return this;
    }

    public MKMapType getMapType() {
        if (this.has(Keys.MapType())) {
            NSNumber val = (NSNumber)this.get(Keys.MapType());
            return MKMapType.valueOf(val.longValue());
        }
        return null;
    }

    public MKLaunchOptions setMapType(MKMapType mapType) {
        this.set(Keys.MapType(), NSNumber.valueOf(mapType.value()));
        return this;
    }

    public boolean showsTraffic() {
        if (this.has(Keys.ShowsTraffic())) {
            NSNumber val = (NSNumber)this.get(Keys.ShowsTraffic());
            return val.booleanValue();
        }
        return false;
    }

    public MKLaunchOptions setShowsTraffic(boolean showsTraffic) {
        this.set(Keys.ShowsTraffic(), NSNumber.valueOf(showsTraffic));
        return this;
    }

    public CLLocationCoordinate2D getMapCenter() {
        if (this.has(Keys.MapCenter())) {
            NSData val = (NSData)this.get(Keys.MapCenter());
            return val.getStructData(CLLocationCoordinate2D.class);
        }
        return null;
    }

    public MKLaunchOptions setMapCenter(CLLocationCoordinate2D mapCenter) {
        this.set(Keys.MapCenter(), new NSData(mapCenter));
        return this;
    }

    public MKCoordinateSpan getMapSpan() {
        if (this.has(Keys.MapSpan())) {
            NSData val = (NSData)this.get(Keys.MapSpan());
            return val.getStructData(MKCoordinateSpan.class);
        }
        return null;
    }

    public MKLaunchOptions setMapSpan(MKCoordinateSpan mapSpan) {
        this.set(Keys.MapSpan(), new NSData(mapSpan));
        return this;
    }

    public MKMapCamera getCamera() {
        if (this.has(Keys.Camera())) {
            MKMapCamera val = (MKMapCamera)this.get(Keys.Camera());
            return val;
        }
        return null;
    }

    public MKLaunchOptions setCamera(MKMapCamera camera) {
        this.set(Keys.Camera(), camera);
        return this;
    }

    @Library(value="MapKit")
    public static class Keys {
        @GlobalValue(symbol="MKLaunchOptionsDirectionsModeKey", optional=true)
        public static native NSString DirectionsMode();

        @GlobalValue(symbol="MKLaunchOptionsMapTypeKey", optional=true)
        public static native NSString MapType();

        @GlobalValue(symbol="MKLaunchOptionsShowsTrafficKey", optional=true)
        public static native NSString ShowsTraffic();

        @GlobalValue(symbol="MKLaunchOptionsMapCenterKey", optional=true)
        public static native NSString MapCenter();

        @GlobalValue(symbol="MKLaunchOptionsMapSpanKey", optional=true)
        public static native NSString MapSpan();

        @GlobalValue(symbol="MKLaunchOptionsCameraKey", optional=true)
        public static native NSString Camera();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<MKLaunchOptions> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<MKLaunchOptions> list = new ArrayList<MKLaunchOptions>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new MKLaunchOptions((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<MKLaunchOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (MKLaunchOptions i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static MKLaunchOptions toObject(Class<MKLaunchOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new MKLaunchOptions(o);
        }

        @MarshalsPointer
        public static long toNative(MKLaunchOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

