/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mapkit;

import org.robovm.apple.coregraphics.CGRectEdge;
import org.robovm.apple.mapkit.MKMapPoint;
import org.robovm.apple.mapkit.MKMapSize;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MapKit")
public class MKMapRect
extends Struct<MKMapRect> {
    public MKMapRect() {
    }

    public MKMapRect(MKMapPoint origin, MKMapSize size) {
        this.setOrigin(origin);
        this.setSize(size);
    }

    public MKMapRect(double x, double y, double width, double height) {
        this.setOrigin(new MKMapPoint(x, y));
        this.setSize(new MKMapSize(width, height));
    }

    @StructMember(value=0)
    @ByVal
    public native MKMapPoint getOrigin();

    @StructMember(value=0)
    public native MKMapRect setOrigin(@ByVal MKMapPoint var1);

    @StructMember(value=1)
    @ByVal
    public native MKMapSize getSize();

    @StructMember(value=1)
    public native MKMapRect setSize(@ByVal MKMapSize var1);

    public double getMinX() {
        return this.getOrigin().getX();
    }

    public double getMinY() {
        return this.getOrigin().getY();
    }

    public double getMidX() {
        return this.getOrigin().getX() + this.getSize().getWidth() / 2.0;
    }

    public double getMidY() {
        return this.getOrigin().getY() + this.getSize().getHeight() / 2.0;
    }

    public double getMaxX() {
        return this.getOrigin().getX() + this.getSize().getWidth();
    }

    public double getMaxY() {
        return this.getOrigin().getY() + this.getSize().getHeight();
    }

    public double getWidth() {
        return this.getSize().getWidth();
    }

    public double getHeight() {
        return this.getSize().getHeight();
    }

    public boolean equalsTo(MKMapRect other) {
        return this.getOrigin().equalsTo(other.getOrigin()) && this.getSize().equalsTo(other.getSize());
    }

    public boolean equals(Object obj) {
        return obj instanceof MKMapRect && this.equalsTo((MKMapRect)((Object)obj));
    }

    public boolean isNull() {
        return this.getOrigin().equalsTo(MKMapRect.Null().getOrigin());
    }

    public boolean isEmpty() {
        return this.isNull() || this.getSize().getWidth() == 0.0 && this.getSize().getHeight() == 0.0;
    }

    public String toString() {
        return String.format("{%s, %s}", this.getOrigin().toString(), this.getSize().toString());
    }

    @GlobalValue(symbol="MKMapRectWorld", optional=true)
    @ByVal
    public static native MKMapRect World();

    @GlobalValue(symbol="MKMapRectNull", optional=true)
    @ByVal
    public static native MKMapRect Null();

    public MKMapRect union(MKMapRect rect2) {
        return MKMapRect.union(this, rect2);
    }

    @Bridge(symbol="MKMapRectUnion", optional=true)
    @ByVal
    private static native MKMapRect union(@ByVal MKMapRect var0, @ByVal MKMapRect var1);

    public MKMapRect intersection(MKMapRect rect2) {
        return MKMapRect.intersection(this, rect2);
    }

    @Bridge(symbol="MKMapRectIntersection", optional=true)
    @ByVal
    private static native MKMapRect intersection(@ByVal MKMapRect var0, @ByVal MKMapRect var1);

    public MKMapRect inset(double dx, double dy) {
        return MKMapRect.inset(this, dx, dy);
    }

    @Bridge(symbol="MKMapRectInset", optional=true)
    @ByVal
    private static native MKMapRect inset(@ByVal MKMapRect var0, double var1, double var3);

    public MKMapRect offset(double dx, double dy) {
        return MKMapRect.offset(this, dx, dy);
    }

    @Bridge(symbol="MKMapRectOffset", optional=true)
    @ByVal
    private static native MKMapRect offset(@ByVal MKMapRect var0, double var1, double var3);

    public void divide(MKMapRect slice, MKMapRect remainder, double amount, CGRectEdge edge) {
        MKMapRect.divide(this, slice, remainder, amount, edge);
    }

    @Bridge(symbol="MKMapRectDivide", optional=true)
    private static native void divide(@ByVal MKMapRect var0, MKMapRect var1, MKMapRect var2, double var3, CGRectEdge var5);

    public boolean contains(MKMapPoint point) {
        return MKMapRect.contains(this, point);
    }

    @Bridge(symbol="MKMapRectContainsPoint", optional=true)
    private static native boolean contains(@ByVal MKMapRect var0, @ByVal MKMapPoint var1);

    public boolean contains(MKMapRect rect2) {
        return MKMapRect.contains(this, rect2);
    }

    @Bridge(symbol="MKMapRectContainsRect", optional=true)
    private static native boolean contains(@ByVal MKMapRect var0, @ByVal MKMapRect var1);

    public boolean intersects(MKMapRect rect2) {
        return MKMapRect.intersects(this, rect2);
    }

    @Bridge(symbol="MKMapRectIntersectsRect", optional=true)
    private static native boolean intersects(@ByVal MKMapRect var0, @ByVal MKMapRect var1);

    public boolean isSpanning180thMeridian() {
        return MKMapRect.isSpanning180thMeridian(this);
    }

    @Bridge(symbol="MKMapRectSpans180thMeridian", optional=true)
    private static native boolean isSpanning180thMeridian(@ByVal MKMapRect var0);

    public MKMapRect remainder() {
        return MKMapRect.remainder(this);
    }

    @Bridge(symbol="MKMapRectRemainder", optional=true)
    @ByVal
    private static native MKMapRect remainder(@ByVal MKMapRect var0);

    static {
        Bro.bind(MKMapRect.class);
    }

    public static class MKMapRectPtr
    extends Ptr<MKMapRect, MKMapRectPtr> {
    }
}

