/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metal;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Marshaler(value=ValuedEnum.AsMachineSizedUIntMarshaler.class)
@Library(value="Metal")
public enum MTLDynamicLibraryError implements NSErrorCode
{
    None(0L),
    InvalidFile(1L),
    CompilationFailure(2L),
    UnresolvedInstallName(3L),
    DependencyLoadFailure(4L),
    Unsupported(5L);

    private final long n;

    @GlobalValue(symbol="MTLDynamicLibraryDomain", optional=true)
    public static native String getClassDomain();

    private MTLDynamicLibraryError(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static MTLDynamicLibraryError valueOf(long n) {
        for (MTLDynamicLibraryError v : MTLDynamicLibraryError.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + MTLDynamicLibraryError.class.getName());
    }

    static {
        Bro.bind(MTLDynamicLibraryError.class);
        Bro.bind(NSErrorWrap.class);
    }

    @StronglyLinked
    public static class NSErrorWrap
    extends NSError {
        protected NSErrorWrap(NSObject.SkipInit skipInit) {
            super(skipInit);
        }

        @Override
        public NSErrorCode getErrorCode() {
            try {
                return MTLDynamicLibraryError.valueOf(this.getCode());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String getClassDomain() {
            return MTLDynamicLibraryError.getClassDomain();
        }
    }
}

