/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.security.SecCredential;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Library(value="Security")
public class SecSharedCredential
extends CocoaUtility {
    public static void requestSharedWebCredential(String fqdn, String account, final VoidBlock2<List<SecCredential>, NSError> completionHandler) {
        SecSharedCredential.requestSharedWebCredential0(fqdn, account, new VoidBlock2<CFArray, NSError>(){

            public void invoke(CFArray a, NSError b) {
                ArrayList<SecCredential> list = null;
                if (a != null) {
                    list = new ArrayList<SecCredential>();
                    int i = 0;
                    while ((long)i < a.size()) {
                        list.add(new SecCredential(a.get(i, CFDictionary.class)));
                        ++i;
                    }
                }
                completionHandler.invoke(list, (Object)b);
            }
        });
    }

    @Bridge(symbol="SecAddSharedWebCredential", optional=true)
    public static native void addSharedWebCredential(String var0, String var1, String var2, @Block VoidBlock1<NSError> var3);

    @Deprecated
    @Bridge(symbol="SecRequestSharedWebCredential", optional=true)
    protected static native void requestSharedWebCredential0(String var0, String var1, @Block VoidBlock2<CFArray, NSError> var2);

    @Bridge(symbol="SecCreateSharedWebCredentialPassword", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public static native String createSharedWebCredentialPassword();

    static {
        Bro.bind(SecSharedCredential.class);
    }
}

