/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.spritekit;

import java.util.List;
import java.util.Map;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.spritekit.SKTexture;
import org.robovm.apple.uikit.UIImage;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="SpriteKit")
@NativeClass
public class SKTextureAtlas
extends NSObject
implements NSSecureCoding {
    public SKTextureAtlas() {
    }

    protected SKTextureAtlas(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected SKTextureAtlas(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public SKTextureAtlas(String name) {
        super(null, SKTextureAtlas.create(name));
        SKTextureAtlas.retain(this.getHandle());
    }

    @Method(selector="initWithCoder:")
    public SKTextureAtlas(NSCoder coder) {
        super(null);
        this.initObject(this.init(coder));
    }

    public SKTextureAtlas(Map<String, ?> textures) {
        super(SKTextureAtlas.create(textures));
        SKTextureAtlas.retain(this.getHandle());
    }

    private static long create(Map<String, ?> textures) {
        NSMutableDictionary properties = new NSMutableDictionary();
        for (Map.Entry<String, ?> entry : textures.entrySet()) {
            NSString key = new NSString(entry.getKey());
            NSObject value = null;
            if (entry.getValue() instanceof String) {
                value = new NSString((String)entry.getValue());
            } else if (entry.getValue() instanceof NSURL || entry.getValue() instanceof UIImage || entry.getValue() instanceof NSString) {
                value = (NSObject)entry.getValue();
            } else {
                throw new IllegalArgumentException("Only String, NSURL, UIImage or NSString are allowed!");
            }
            ((NSDictionary)properties).put((Object)key, value);
        }
        return SKTextureAtlas.create(properties);
    }

    @Property(selector="textureNames")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getTextureNames();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    @Method(selector="textureNamed:")
    public native SKTexture getTexture(String var1);

    @Method(selector="preloadWithCompletionHandler:")
    public native void preload(@Block Runnable var1);

    @Method(selector="atlasNamed:")
    @Pointer
    protected static native long create(String var0);

    @Method(selector="atlasWithDictionary:")
    @Pointer
    protected static native long create(NSDictionary<NSString, ?> var0);

    @Method(selector="preloadTextureAtlases:withCompletionHandler:")
    public static native void preloadTextureAtlases(NSArray<SKTextureAtlas> var0, @Block Runnable var1);

    @Method(selector="preloadTextureAtlasesNamed:withCompletionHandler:")
    public static native void preloadTextureAtlases(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var0, @Block VoidBlock2<NSError, NSArray<SKTextureAtlas>> var1);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(SKTextureAtlas.class);
    }

    public static class SKTextureAtlasPtr
    extends Ptr<SKTextureAtlas, SKTextureAtlasPtr> {
    }
}

