/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.systemconfiguration;

import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFRunLoop;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.dispatch.DispatchQueue;
import org.robovm.apple.systemconfiguration.SCNetworkReachabilityContext;
import org.robovm.apple.systemconfiguration.SCNetworkReachabilityFlags;
import org.robovm.apple.systemconfiguration.sockaddr_in;
import org.robovm.apple.systemconfiguration.sockaddr_in6;
import org.robovm.objc.LongMap;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="SystemConfiguration")
public class SCNetworkReachability
extends CFType {
    private static AtomicLong refconId = new AtomicLong();
    private long localRefconId;
    private static LongMap<ClientCallback> callbacks = new LongMap();
    private static final Method cbInvoke;

    protected SCNetworkReachability() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbInvoke(SCNetworkReachability target, SCNetworkReachabilityFlags flags, @Pointer long refcon) {
        ClientCallback callback = null;
        LongMap<ClientCallback> longMap = callbacks;
        synchronized (longMap) {
            callback = (ClientCallback)callbacks.get(refcon);
        }
        callback.invoke(target, flags);
    }

    public SCNetworkReachability(InetSocketAddress address) {
        long reachability;
        long refconId = SCNetworkReachability.refconId.getAndIncrement();
        InetAddress addr = address.getAddress();
        if (addr instanceof Inet4Address) {
            reachability = SCNetworkReachability.create(null, new sockaddr_in(address));
        } else if (addr instanceof Inet6Address) {
            reachability = SCNetworkReachability.create(null, new sockaddr_in6(address));
        } else {
            throw new IllegalArgumentException("address is not a valid IPv4 or IPv6 address!");
        }
        this.localRefconId = refconId;
        this.setHandle(reachability);
    }

    public SCNetworkReachability(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        Struct r;
        Struct l;
        long refconId = SCNetworkReachability.refconId.getAndIncrement();
        if (localAddress.getAddress() instanceof Inet4Address) {
            l = new sockaddr_in(localAddress);
        } else if (localAddress.getAddress() instanceof Inet6Address) {
            l = new sockaddr_in6(localAddress);
        } else {
            throw new IllegalArgumentException("localAddress is not a valid IPv4 or IPv6 address!");
        }
        if (remoteAddress.getAddress() instanceof Inet4Address) {
            r = new sockaddr_in(remoteAddress);
        } else if (remoteAddress.getAddress() instanceof Inet6Address) {
            r = new sockaddr_in6(remoteAddress);
        } else {
            throw new IllegalArgumentException("remoteAddress is not a valid IPv4 or IPv6 address!");
        }
        long reachability = SCNetworkReachability.create(null, l, r);
        this.localRefconId = refconId;
        this.setHandle(reachability);
    }

    public SCNetworkReachability(String nodename) {
        long refconId = SCNetworkReachability.refconId.getAndIncrement();
        BytePtr ptr = BytePtr.toBytePtrZ((String)nodename);
        long reachability = SCNetworkReachability.create(null, ptr);
        this.localRefconId = refconId;
        this.setHandle(reachability);
    }

    public SCNetworkReachabilityFlags getFlags() {
        IntPtr ptr = new IntPtr();
        this.getFlags(ptr);
        return new SCNetworkReachabilityFlags(ptr.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCallback(ClientCallback callback) {
        SCNetworkReachabilityContext context = new SCNetworkReachabilityContext();
        context.setInfo(this.localRefconId);
        LongMap<ClientCallback> longMap = callbacks;
        synchronized (longMap) {
            callbacks.put(this.localRefconId, (Object)callback);
        }
        return this.setCallback(new FunctionPtr(cbInvoke), context);
    }

    @Bridge(symbol="SCNetworkReachabilityCreateWithAddress", optional=true)
    @Pointer
    private static native long create(CFAllocator var0, Struct<?> var1);

    @Bridge(symbol="SCNetworkReachabilityCreateWithAddressPair", optional=true)
    @Pointer
    private static native long create(CFAllocator var0, Struct<?> var1, Struct<?> var2);

    @Bridge(symbol="SCNetworkReachabilityCreateWithName", optional=true)
    @Pointer
    private static native long create(CFAllocator var0, BytePtr var1);

    @Bridge(symbol="SCNetworkReachabilityGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="SCNetworkReachabilityGetFlags", optional=true)
    protected native boolean getFlags(IntPtr var1);

    @Bridge(symbol="SCNetworkReachabilitySetCallback", optional=true)
    protected native boolean setCallback(FunctionPtr var1, SCNetworkReachabilityContext var2);

    @Bridge(symbol="SCNetworkReachabilityScheduleWithRunLoop", optional=true)
    public native boolean schedule(CFRunLoop var1, CFString var2);

    @Bridge(symbol="SCNetworkReachabilityUnscheduleFromRunLoop", optional=true)
    public native boolean unschedule(CFRunLoop var1, CFString var2);

    @Bridge(symbol="SCNetworkReachabilitySetDispatchQueue", optional=true)
    @WeaklyLinked
    public native boolean setDispatchQueue(DispatchQueue var1);

    static {
        try {
            cbInvoke = SCNetworkReachability.class.getDeclaredMethod("cbInvoke", SCNetworkReachability.class, SCNetworkReachabilityFlags.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(SCNetworkReachability.class);
    }

    public static interface ClientCallback {
        public void invoke(SCNetworkReachability var1, SCNetworkReachabilityFlags var2);
    }

    public static class SCNetworkReachabilityPtr
    extends Ptr<SCNetworkReachability, SCNetworkReachabilityPtr> {
    }
}

