/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSValue;
import org.robovm.apple.uikit.UIViewAnimationCurve;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="UIKit")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class UIKeyboardAnimation
extends NSDictionaryWrapper {
    UIKeyboardAnimation(NSDictionary data) {
        super(data);
    }

    public UIKeyboardAnimation() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public UIKeyboardAnimation set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public CGRect getStartFrame() {
        if (this.has(Keys.FrameBegin())) {
            NSValue val = (NSValue)this.get(Keys.FrameBegin());
            return val.rectValue();
        }
        return null;
    }

    public UIKeyboardAnimation setStartFrame(CGRect startFrame) {
        this.set(Keys.FrameBegin(), NSValue.valueOf(startFrame));
        return this;
    }

    public CGRect getEndFrame() {
        if (this.has(Keys.FrameEnd())) {
            NSValue val = (NSValue)this.get(Keys.FrameEnd());
            return val.rectValue();
        }
        return null;
    }

    public UIKeyboardAnimation setEndFrame(CGRect endFrame) {
        this.set(Keys.FrameEnd(), NSValue.valueOf(endFrame));
        return this;
    }

    public double getAnimationDuration() {
        if (this.has(Keys.AnimationDuration())) {
            NSNumber val = (NSNumber)this.get(Keys.AnimationDuration());
            return val.doubleValue();
        }
        return 0.0;
    }

    public UIKeyboardAnimation setAnimationDuration(double animationDuration) {
        this.set(Keys.AnimationDuration(), NSNumber.valueOf(animationDuration));
        return this;
    }

    public UIViewAnimationCurve getAnimationCurve() {
        if (this.has(Keys.AnimationCurve())) {
            NSNumber val = (NSNumber)this.get(Keys.AnimationCurve());
            return UIViewAnimationCurve.valueOf(val.longValue());
        }
        return null;
    }

    public UIKeyboardAnimation setAnimationCurve(UIViewAnimationCurve animationCurve) {
        this.set(Keys.AnimationCurve(), NSNumber.valueOf(animationCurve.value()));
        return this;
    }

    public boolean isLocal() {
        if (this.has(Keys.IsLocal())) {
            NSNumber val = (NSNumber)this.get(Keys.IsLocal());
            return val.booleanValue();
        }
        return false;
    }

    public UIKeyboardAnimation setLocal(boolean local) {
        this.set(Keys.IsLocal(), NSNumber.valueOf(local));
        return this;
    }

    @Library(value="UIKit")
    public static class Keys {
        @GlobalValue(symbol="UIKeyboardFrameBeginUserInfoKey", optional=true)
        public static native NSString FrameBegin();

        @GlobalValue(symbol="UIKeyboardFrameEndUserInfoKey", optional=true)
        public static native NSString FrameEnd();

        @GlobalValue(symbol="UIKeyboardAnimationDurationUserInfoKey", optional=true)
        public static native NSString AnimationDuration();

        @GlobalValue(symbol="UIKeyboardAnimationCurveUserInfoKey", optional=true)
        public static native NSString AnimationCurve();

        @GlobalValue(symbol="UIKeyboardIsLocalUserInfoKey", optional=true)
        public static native NSString IsLocal();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<UIKeyboardAnimation> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<UIKeyboardAnimation> list = new ArrayList<UIKeyboardAnimation>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new UIKeyboardAnimation((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<UIKeyboardAnimation> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (UIKeyboardAnimation i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static UIKeyboardAnimation toObject(Class<UIKeyboardAnimation> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new UIKeyboardAnimation(o);
        }

        @MarshalsPointer
        public static long toNative(UIKeyboardAnimation o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

