/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="UIKit")
public class UIRemoteNotification
extends NSDictionaryWrapper {
    private static final NSString APS = new NSString("aps");
    private static final NSString ALERT = new NSString("alert");
    private static final NSString BODY = new NSString("body");
    private static final NSString SHOW_VIEW = new NSString("show-view");
    private static final NSString BADGE = new NSString("badge");
    private static final NSString SOUND = new NSString("sound");

    protected UIRemoteNotification(NSDictionary<NSString, NSObject> data) {
        super(data);
    }

    public String getAlert() {
        NSDictionary aps = (NSDictionary)this.data.get(APS);
        if (aps != null && aps.containsKey(ALERT)) {
            NSDictionary alert;
            Object val = aps.get(ALERT);
            if (val instanceof NSString) {
                return ((NSObject)val).toString();
            }
            if (val instanceof NSDictionary && (alert = (NSDictionary)val).containsKey(BODY)) {
                NSString body = (NSString)alert.get(BODY);
                return body.toString();
            }
        }
        return null;
    }

    public boolean isViewButtonShown() {
        NSDictionary alert;
        Object val;
        NSDictionary aps = (NSDictionary)this.data.get(APS);
        if (aps != null && aps.containsKey(ALERT) && (val = aps.get(ALERT)) instanceof NSDictionary && (alert = (NSDictionary)val).containsKey(SHOW_VIEW)) {
            NSNumber showView = (NSNumber)alert.get(SHOW_VIEW);
            return showView.booleanValue();
        }
        return true;
    }

    public long getBadgeNumber() {
        NSDictionary aps = (NSDictionary)this.data.get(APS);
        if (aps != null && aps.containsKey(BADGE)) {
            NSString val = (NSString)aps.get(BADGE);
            return Long.valueOf(val.toString());
        }
        return -1L;
    }

    public String getSound() {
        NSDictionary aps = (NSDictionary)this.data.get(APS);
        if (aps != null && aps.containsKey(SOUND)) {
            NSString val = (NSString)aps.get(SOUND);
            return val.toString();
        }
        return null;
    }

    public NSObject get(String key) {
        return this.data.get(key);
    }

    public String getString(String key) {
        return this.data.getString(key, null);
    }

    static {
        Bro.bind(UIRemoteNotification.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static UIRemoteNotification toObject(Class<UIRemoteNotification> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new UIRemoteNotification((NSDictionary<NSString, NSObject>)o);
        }

        @MarshalsPointer
        public static long toNative(UIRemoteNotification o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

