/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.vision;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.VectorFloat2;
import org.robovm.apple.vision.VNCircle;
import org.robovm.apple.vision.VNContour;
import org.robovm.apple.vision.VNPoint;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Vision")
@NativeClass
public class VNGeometryUtils
extends NSObject {
    public VNGeometryUtils() {
    }

    protected VNGeometryUtils(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected VNGeometryUtils(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public static VNCircle getBoundingCircle(VNContour contour) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        VNCircle result = VNGeometryUtils.getBoundingCircle(contour, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="boundingCircleForContour:error:")
    private static native VNCircle getBoundingCircle(VNContour var0, NSError.NSErrorPtr var1);

    public static VNCircle getBoundingCircle(NSArray<VNPoint> points) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        VNCircle result = VNGeometryUtils.getBoundingCircle(points, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="boundingCircleForPoints:error:")
    private static native VNCircle getBoundingCircle(NSArray<VNPoint> var0, NSError.NSErrorPtr var1);

    public static VNCircle getBoundingCircle(VectorFloat2 points, @MachineSizedSInt long pointCount) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        VNCircle result = VNGeometryUtils.getBoundingCircle(points, pointCount, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="boundingCircleForSIMDPoints:pointCount:error:")
    private static native VNCircle getBoundingCircle(VectorFloat2 var0, @MachineSizedSInt long var1, NSError.NSErrorPtr var3);

    public static boolean calculateArea(DoublePtr area, VNContour contour, boolean orientedArea) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = VNGeometryUtils.calculateArea(area, contour, orientedArea, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="calculateArea:forContour:orientedArea:error:")
    private static native boolean calculateArea(DoublePtr var0, VNContour var1, boolean var2, NSError.NSErrorPtr var3);

    public static boolean calculatePerimeter(DoublePtr perimeter, VNContour contour) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = VNGeometryUtils.calculatePerimeter(perimeter, contour, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="calculatePerimeter:forContour:error:")
    private static native boolean calculatePerimeter(DoublePtr var0, VNContour var1, NSError.NSErrorPtr var2);

    static {
        ObjCRuntime.bind(VNGeometryUtils.class);
    }

    public static class VNGeometryUtilsPtr
    extends Ptr<VNGeometryUtils, VNGeometryUtilsPtr> {
    }
}

