/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.addressbook;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corefoundation.*;
/*</imports>*/

/*<javadoc>*/
/*</javadoc>*/
/*<annotations>*/@Library("AddressBook") @StronglyLinked/*</annotations>*/
@Marshaler(/*<name>*/ABPersonSocialProfileService/*</name>*/.Marshaler.class)
/*<visibility>*/public/*</visibility>*/ class /*<name>*/ABPersonSocialProfileService/*</name>*/ 
    extends /*<extends>*/GlobalValueEnumeration<CFString>/*</extends>*/
    /*<implements>*//*</implements>*/ {

    static { Bro.bind(/*<name>*/ABPersonSocialProfileService/*</name>*/.class); }

    /*<marshalers>*/
    public static class Marshaler {
        @MarshalsPointer
        public static ABPersonSocialProfileService toObject(Class<ABPersonSocialProfileService> cls, long handle, long flags) {
            CFString o = (CFString) CFType.Marshaler.toObject(CFString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return ABPersonSocialProfileService.valueOf(o);
        }
        @MarshalsPointer
        public static long toNative(ABPersonSocialProfileService o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.value(), flags);
        }
    }
    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<ABPersonSocialProfileService> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray) CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            List<ABPersonSocialProfileService> list = new ArrayList<>();
            for (int i = 0; i < o.size(); i++) {
                list.add(ABPersonSocialProfileService.valueOf(o.get(i, CFString.class)));
            }
            return list;
        }
        @MarshalsPointer
        public static long toNative(List<ABPersonSocialProfileService> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFArray array = CFMutableArray.create();
            for (ABPersonSocialProfileService o : l) {
                array.add(o.value());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }
    /*</marshalers>*/

    /*<constants>*/
    /**
     * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceTwitter
     */
    @Deprecated
    public static final ABPersonSocialProfileService Twitter = new ABPersonSocialProfileService("Twitter");
    /**
     * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceSinaWeibo
     */
    @Deprecated
    public static final ABPersonSocialProfileService SinaWeibo = new ABPersonSocialProfileService("SinaWeibo");
    /**
     * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceGameCenter
     */
    @Deprecated
    public static final ABPersonSocialProfileService GameCenter = new ABPersonSocialProfileService("GameCenter");
    /**
     * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceFacebook
     */
    @Deprecated
    public static final ABPersonSocialProfileService Facebook = new ABPersonSocialProfileService("Facebook");
    /**
     * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceMySpace
     */
    @Deprecated
    public static final ABPersonSocialProfileService Myspace = new ABPersonSocialProfileService("Myspace");
    /**
     * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceLinkedIn
     */
    @Deprecated
    public static final ABPersonSocialProfileService LinkedIn = new ABPersonSocialProfileService("LinkedIn");
    /**
     * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceFlickr
     */
    @Deprecated
    public static final ABPersonSocialProfileService Flickr = new ABPersonSocialProfileService("Flickr");
    /*</constants>*/
    
    private static /*<name>*/ABPersonSocialProfileService/*</name>*/[] values = new /*<name>*/ABPersonSocialProfileService/*</name>*/[] {/*<value_list>*/Twitter, SinaWeibo, GameCenter, Facebook, Myspace, LinkedIn, Flickr/*</value_list>*/};
    
    /*<name>*/ABPersonSocialProfileService/*</name>*/ (String getterName) {
        super(Values.class, getterName);
    }
    
    public static /*<name>*/ABPersonSocialProfileService/*</name>*/ valueOf(/*<type>*/CFString/*</type>*/ value) {
        for (/*<name>*/ABPersonSocialProfileService/*</name>*/ v : values) {
            if (v.value().equals(value)) {
                return v;
            }
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " 
            + /*<name>*/ABPersonSocialProfileService/*</name>*/.class.getName());
    }
    
    /*<methods>*//*</methods>*/
    
    /*<annotations>*/@Library("AddressBook") @StronglyLinked/*</annotations>*/
    public static class Values {
    	static { Bro.bind(Values.class); }

        /*<values>*/
        /**
         * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceTwitter
         */
        @Deprecated
        @GlobalValue(symbol="kABPersonSocialProfileServiceTwitter", optional=true)
        public static native CFString Twitter();
        /**
         * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceSinaWeibo
         */
        @Deprecated
        @GlobalValue(symbol="kABPersonSocialProfileServiceSinaWeibo", optional=true)
        public static native CFString SinaWeibo();
        /**
         * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceGameCenter
         */
        @Deprecated
        @GlobalValue(symbol="kABPersonSocialProfileServiceGameCenter", optional=true)
        public static native CFString GameCenter();
        /**
         * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceFacebook
         */
        @Deprecated
        @GlobalValue(symbol="kABPersonSocialProfileServiceFacebook", optional=true)
        public static native CFString Facebook();
        /**
         * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceMySpace
         */
        @Deprecated
        @GlobalValue(symbol="kABPersonSocialProfileServiceMyspace", optional=true)
        public static native CFString Myspace();
        /**
         * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceLinkedIn
         */
        @Deprecated
        @GlobalValue(symbol="kABPersonSocialProfileServiceLinkedIn", optional=true)
        public static native CFString LinkedIn();
        /**
         * @deprecated Deprecated in iOS 9.0. use CNSocialProfileServiceFlickr
         */
        @Deprecated
        @GlobalValue(symbol="kABPersonSocialProfileServiceFlickr", optional=true)
        public static native CFString Flickr();
        /*</values>*/
    }
}
