/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.cloudkit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corelocation.*;
import org.robovm.apple.contacts.*;
import org.robovm.apple.fileprovider.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @deprecated Deprecated in iOS 10.0. Use CKUserIdentity
 */
/*</javadoc>*/
/*<annotations>*/@Library("CloudKit") @NativeClass @Deprecated/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/CKDiscoveredUserInfo/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class CKDiscoveredUserInfoPtr extends Ptr<CKDiscoveredUserInfo, CKDiscoveredUserInfoPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(CKDiscoveredUserInfo.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    protected CKDiscoveredUserInfo() {}
    protected CKDiscoveredUserInfo(Handle h, long handle) { super(h, handle); }
    protected CKDiscoveredUserInfo(SkipInit skipInit) { super(skipInit); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "userRecordID")
    public native CKRecordID getUserRecordID();
    /**
     * @deprecated Deprecated in iOS 9.0. Use CKDiscoveredUserInfo.displayContact.givenName
     */
    @Deprecated
    @Property(selector = "firstName")
    public native String getFirstName();
    /**
     * @deprecated Deprecated in iOS 9.0. Use CKDiscoveredUserInfo.displayContact.familyName
     */
    @Deprecated
    @Property(selector = "lastName")
    public native String getLastName();
    /**
     * @since Available in iOS 9.0 and later.
     */
    @Property(selector = "displayContact")
    public native CNContact getDisplayContact();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    
    /*</methods>*/
}
