/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.coredata;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corespotlight.*;
import org.robovm.apple.cloudkit.*;
import org.robovm.apple.uikit.*;
/*</imports>*/

/*<javadoc>*/

/*</javadoc>*/
/*<annotations>*/@Library("CoreData") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/NSAsynchronousFetchResult<ResultType extends NSObject & NSFetchRequestResult>/*</name>*/ 
    extends /*<extends>*/NSPersistentStoreAsynchronousResult/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class NSAsynchronousFetchResultPtr<ResultType extends NSObject & NSFetchRequestResult> extends Ptr<NSAsynchronousFetchResult<ResultType>, NSAsynchronousFetchResultPtr<ResultType>> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(NSAsynchronousFetchResult.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public NSAsynchronousFetchResult() {}
    protected NSAsynchronousFetchResult(Handle h, long handle) { super(h, handle); }
    protected NSAsynchronousFetchResult(SkipInit skipInit) { super(skipInit); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "fetchRequest")
    public native NSAsynchronousFetchRequest<ResultType> getFetchRequest();
    @Property(selector = "finalResult")
    public native NSArray<NSManagedObject> getFinalResult();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    
    /*</methods>*/
}
