/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.coreimage;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corefoundation.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.opengles.*;
import org.robovm.apple.corevideo.*;
import org.robovm.apple.imageio.*;
import org.robovm.apple.uikit.*;
import org.robovm.apple.metal.*;
import org.robovm.apple.iosurface.*;
import org.robovm.apple.avfoundation.*;
/*</imports>*/

/*<javadoc>*/

/*</javadoc>*/
/*<annotations>*/@Library("CoreImage") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/CIFaceFeature/*</name>*/ 
    extends /*<extends>*/CIFeature/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class CIFaceFeaturePtr extends Ptr<CIFaceFeature, CIFaceFeaturePtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(CIFaceFeature.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public CIFaceFeature() {}
    protected CIFaceFeature(Handle h, long handle) { super(h, handle); }
    protected CIFaceFeature(SkipInit skipInit) { super(skipInit); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "bounds")
    public native @ByVal CGRect getBounds();
    @Property(selector = "hasLeftEyePosition")
    public native boolean hasLeftEyePosition();
    @Property(selector = "leftEyePosition")
    public native @ByVal CGPoint getLeftEyePosition();
    @Property(selector = "hasRightEyePosition")
    public native boolean hasRightEyePosition();
    @Property(selector = "rightEyePosition")
    public native @ByVal CGPoint getRightEyePosition();
    @Property(selector = "hasMouthPosition")
    public native boolean hasMouthPosition();
    @Property(selector = "mouthPosition")
    public native @ByVal CGPoint getMouthPosition();
    @Property(selector = "hasTrackingID")
    public native boolean hasTrackingID();
    @Property(selector = "trackingID")
    public native int getTrackingID();
    @Property(selector = "hasTrackingFrameCount")
    public native boolean hasTrackingFrameCount();
    @Property(selector = "trackingFrameCount")
    public native int getTrackingFrameCount();
    @Property(selector = "hasFaceAngle")
    public native boolean hasFaceAngle();
    @Property(selector = "faceAngle")
    public native float getFaceAngle();
    @Property(selector = "hasSmile")
    public native boolean hasSmile();
    @Property(selector = "leftEyeClosed")
    public native boolean isLeftEyeClosed();
    @Property(selector = "rightEyeClosed")
    public native boolean isRightEyeClosed();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    
    /*</methods>*/
}
