/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.homekit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corelocation.*;
/*</imports>*/

/*<javadoc>*/
/*</javadoc>*/
/*<annotations>*//*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/HMAccessoryDelegateAdapter/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*/implements HMAccessoryDelegate/*</implements>*/ {

    /*<ptr>*/
    /*</ptr>*/
    /*<bind>*/
    /*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*//*</constructors>*/
    /*<properties>*/
    
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    @NotImplemented("accessoryDidUpdateName:")
    public void didUpdateName(HMAccessory accessory) {}
    @NotImplemented("accessory:didUpdateNameForService:")
    public void didUpdateServiceName(HMAccessory accessory, HMService service) {}
    @NotImplemented("accessory:didUpdateAssociatedServiceTypeForService:")
    public void didUpdateAssociatedServiceType(HMAccessory accessory, HMService service) {}
    @NotImplemented("accessoryDidUpdateServices:")
    public void didUpdateServices(HMAccessory accessory) {}
    /**
     * @since Available in iOS 11.0 and later.
     */
    @NotImplemented("accessory:didAddProfile:")
    public void didAddProfile(HMAccessory accessory, HMAccessoryProfile profile) {}
    /**
     * @since Available in iOS 11.0 and later.
     */
    @NotImplemented("accessory:didRemoveProfile:")
    public void didRemoveProfile(HMAccessory accessory, HMAccessoryProfile profile) {}
    @NotImplemented("accessoryDidUpdateReachability:")
    public void didUpdateReachability(HMAccessory accessory) {}
    @NotImplemented("accessory:service:didUpdateValueForCharacteristic:")
    public void didUpdateCharacteristicValue(HMAccessory accessory, HMService service, HMCharacteristic characteristic) {}
    /**
     * @since Available in iOS 11.0 and later.
     */
    @NotImplemented("accessory:didUpdateFirmwareVersion:")
    public void didUpdateFirmwareVersion(HMAccessory accessory, String firmwareVersion) {}
    /*</methods>*/
}
