/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.imagecapturecore;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.uikit.*;
/*</imports>*/

/*<javadoc>*/
/*</javadoc>*/
/*<annotations>*/@Library("ImageCaptureCore")/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/ICDeviceCapability/*</name>*/ 
    extends /*<extends>*/CocoaUtility/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/
    /*</ptr>*/
    /*<bind>*/static { Bro.bind(ICDeviceCapability.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*//*</constructors>*/
    /*<properties>*//*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    /**
     * @since Available in iOS 13.0 and later.
     */
    @GlobalValue(symbol="ICDeviceCanEjectOrDisconnect", optional=true)
    public static native NSString DeviceCanEjectOrDisconnect();
    /**
     * @since Available in iOS 13.0 and later.
     */
    @GlobalValue(symbol="ICCameraDeviceCanTakePicture", optional=true)
    public static native NSString CameraDeviceCanTakePicture();
    /**
     * @since Available in iOS 13.0 and later.
     */
    @GlobalValue(symbol="ICCameraDeviceCanTakePictureUsingShutterReleaseOnCamera", optional=true)
    public static native NSString CameraDeviceCanTakePictureUsingShutterReleaseOnCamera();
    /**
     * @since Available in iOS 13.0 and later.
     */
    @GlobalValue(symbol="ICCameraDeviceCanDeleteOneFile", optional=true)
    public static native NSString CameraDeviceCanDeleteOneFile();
    /**
     * @since Available in iOS 13.0 and later.
     */
    @GlobalValue(symbol="ICCameraDeviceCanDeleteAllFiles", optional=true)
    public static native NSString CameraDeviceCanDeleteAllFiles();
    /**
     * @since Available in iOS 13.0 and later.
     */
    @GlobalValue(symbol="ICCameraDeviceCanSyncClock", optional=true)
    public static native NSString CameraDeviceCanSyncClock();
    /**
     * @since Available in iOS 13.0 and later.
     */
    @GlobalValue(symbol="ICCameraDeviceCanReceiveFile", optional=true)
    public static native NSString CameraDeviceCanReceiveFile();
    /**
     * @since Available in iOS 13.0 and later.
     */
    @GlobalValue(symbol="ICCameraDeviceCanAcceptPTPCommands", optional=true)
    public static native NSString CameraDeviceCanAcceptPTPCommands();
    /**
     * @since Available in iOS 14.0 and later.
     */
    @GlobalValue(symbol="ICCameraDeviceSupportsHEIF", optional=true)
    public static native NSString CameraDeviceSupportsHEIF();
    /*</methods>*/
}
