/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.intents;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.eventkit.*;
import org.robovm.apple.corelocation.*;
import org.robovm.apple.coregraphics.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 10.3 and later.
 * @deprecated Deprecated in iOS 15.0. INBillPayee is deprecated. There is no replacement
 */
/*</javadoc>*/
/*<annotations>*/@Library("Intents") @NativeClass @Deprecated/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/INBillPayee/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*/implements NSSecureCoding/*</implements>*/ {

    /*<ptr>*/public static class INBillPayeePtr extends Ptr<INBillPayee, INBillPayeePtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(INBillPayee.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    protected INBillPayee() {}
    protected INBillPayee(Handle h, long handle) { super(h, handle); }
    protected INBillPayee(SkipInit skipInit) { super(skipInit); }
    @Method(selector = "initWithNickname:number:organizationName:")
    public INBillPayee(INSpeakableString nickname, String number, INSpeakableString organizationName) { super((SkipInit) null); initObject(init(nickname, number, organizationName)); }
    @Method(selector = "initWithCoder:")
    public INBillPayee(NSCoder coder) { super((SkipInit) null); initObject(init(coder)); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "nickname")
    public native INSpeakableString getNickname();
    @Property(selector = "accountNumber")
    public native String getAccountNumber();
    @Property(selector = "organizationName")
    public native INSpeakableString getOrganizationName();
    @Property(selector = "supportsSecureCoding")
    public static native boolean supportsSecureCoding();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    @Method(selector = "initWithNickname:number:organizationName:")
    protected native @Pointer long init(INSpeakableString nickname, String number, INSpeakableString organizationName);
    @Method(selector = "encodeWithCoder:")
    public native void encode(NSCoder coder);
    @Method(selector = "initWithCoder:")
    protected native @Pointer long init(NSCoder coder);
    /*</methods>*/
}
