/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.mapkit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.corelocation.*;
import org.robovm.apple.uikit.*;
import org.robovm.apple.dispatch.*;
import org.robovm.apple.coreanimation.*;
/*</imports>*/

/*<javadoc>*/

/*</javadoc>*/
/*<annotations>*/@Library("MapKit") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/MKETAResponse/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class MKETAResponsePtr extends Ptr<MKETAResponse, MKETAResponsePtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(MKETAResponse.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public MKETAResponse() {}
    protected MKETAResponse(Handle h, long handle) { super(h, handle); }
    protected MKETAResponse(SkipInit skipInit) { super(skipInit); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "source")
    public native MKMapItem getSource();
    @Property(selector = "destination")
    public native MKMapItem getDestination();
    @Property(selector = "expectedTravelTime")
    public native double getExpectedTravelTime();
    /**
     * @since Available in iOS 9.0 and later.
     */
    @Property(selector = "distance")
    public native double getDistance();
    /**
     * @since Available in iOS 9.0 and later.
     */
    @Property(selector = "expectedArrivalDate")
    public native NSDate getExpectedArrivalDate();
    /**
     * @since Available in iOS 9.0 and later.
     */
    @Property(selector = "expectedDepartureDate")
    public native NSDate getExpectedDepartureDate();
    /**
     * @since Available in iOS 9.0 and later.
     */
    @Property(selector = "transportType")
    public native MKDirectionsTransportType getTransportType();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    
    /*</methods>*/
}
