/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.metalps;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.metal.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 11.3 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("MetalPerformanceShaders") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/MPSNNReduceFeatureChannelsAndWeightsSum/*</name>*/ 
    extends /*<extends>*/MPSNNReduceBinary/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class MPSNNReduceFeatureChannelsAndWeightsSumPtr extends Ptr<MPSNNReduceFeatureChannelsAndWeightsSum, MPSNNReduceFeatureChannelsAndWeightsSumPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(MPSNNReduceFeatureChannelsAndWeightsSum.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public MPSNNReduceFeatureChannelsAndWeightsSum() {}
    protected MPSNNReduceFeatureChannelsAndWeightsSum(Handle h, long handle) { super(h, handle); }
    protected MPSNNReduceFeatureChannelsAndWeightsSum(SkipInit skipInit) { super(skipInit); }
    @Method(selector = "initWithDevice:")
    public MPSNNReduceFeatureChannelsAndWeightsSum(MTLDevice device) { super((SkipInit) null); initObject(init(device)); }
    @Method(selector = "initWithDevice:doWeightedSumByNonZeroWeights:")
    public MPSNNReduceFeatureChannelsAndWeightsSum(MTLDevice device, boolean doWeightedSumByNonZeroWeights) { super((SkipInit) null); initObject(init(device, doWeightedSumByNonZeroWeights)); }
    @Method(selector = "initWithCoder:device:")
    public MPSNNReduceFeatureChannelsAndWeightsSum(NSCoder decoder, MTLDevice device) { super((SkipInit) null); initObject(init(decoder, device)); }
    @Method(selector = "initWithCoder:")
    public MPSNNReduceFeatureChannelsAndWeightsSum(NSCoder coder) { super(coder); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "doWeightedSumByNonZeroWeights")
    public native boolean isDoWeightedSumByNonZeroWeights();
    @Property(selector = "supportsSecureCoding")
    public static native boolean supportsSecureCoding();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    @Method(selector = "initWithDevice:")
    protected native @Pointer long init(MTLDevice device);
    @Method(selector = "initWithDevice:doWeightedSumByNonZeroWeights:")
    protected native @Pointer long init(MTLDevice device, boolean doWeightedSumByNonZeroWeights);
    @Method(selector = "initWithCoder:device:")
    protected native @Pointer long init(NSCoder decoder, MTLDevice device);
    /*</methods>*/
}
