/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.networkextension;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.security.*;
import org.robovm.apple.network.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 11.0 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("NetworkExtension") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/NEDNSProxyProvider/*</name>*/ 
    extends /*<extends>*/NEProvider/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class NEDNSProxyProviderPtr extends Ptr<NEDNSProxyProvider, NEDNSProxyProviderPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(NEDNSProxyProvider.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public NEDNSProxyProvider() {}
    protected NEDNSProxyProvider(Handle h, long handle) { super(h, handle); }
    protected NEDNSProxyProvider(SkipInit skipInit) { super(skipInit); }
    /*</constructors>*/
    /*<properties>*/
    /**
     * @since Available in iOS 11.0 and later.
     */
    @Property(selector = "systemDNSSettings")
    public native NSArray<NEDNSSettings> getSystemDNSSettings();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    /**
     * @since Available in iOS 11.0 and later.
     */
    @Method(selector = "startProxyWithOptions:completionHandler:")
    public native void startProxy(NSDictionary<NSString, ?> options, @Block VoidBlock1<NSError> completionHandler);
    /**
     * @since Available in iOS 11.0 and later.
     */
    @Method(selector = "stopProxyWithReason:completionHandler:")
    public native void stopProxy(NEProviderStopReason reason, @Block Runnable completionHandler);
    /**
     * @since Available in iOS 11.0 and later.
     */
    @Method(selector = "cancelProxyWithError:")
    public native void cancelProxy(NSError error);
    /**
     * @since Available in iOS 11.0 and later.
     */
    @Method(selector = "handleNewFlow:")
    public native boolean handleNewFlow(NEAppProxyFlow flow);
    /**
     * @since Available in iOS 13.0 and later.
     */
    @Method(selector = "handleNewUDPFlow:initialRemoteEndpoint:")
    public native boolean handleNewUDPFlow(NEAppProxyUDPFlow flow, NWEndpoint remoteEndpoint);
    /*</methods>*/
}
