/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.passkit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.uikit.*;
import org.robovm.apple.addressbook.*;
import org.robovm.apple.contacts.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.coreanimation.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 9.0 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("PassKit") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/PKContact/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class PKContactPtr extends Ptr<PKContact, PKContactPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(PKContact.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public PKContact() {}
    protected PKContact(Handle h, long handle) { super(h, handle); }
    protected PKContact(SkipInit skipInit) { super(skipInit); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "name")
    public native NSPersonNameComponents getName();
    @Property(selector = "setName:")
    public native void setName(NSPersonNameComponents v);
    @Property(selector = "postalAddress")
    public native CNPostalAddress getPostalAddress();
    @Property(selector = "setPostalAddress:")
    public native void setPostalAddress(CNPostalAddress v);
    @Property(selector = "phoneNumber")
    public native CNPhoneNumber getPhoneNumber();
    @Property(selector = "setPhoneNumber:")
    public native void setPhoneNumber(CNPhoneNumber v);
    @Property(selector = "emailAddress")
    public native String getEmailAddress();
    @Property(selector = "setEmailAddress:")
    public native void setEmailAddress(String v);
    /**
     * @since Available in iOS 9.2 and later.
     * @deprecated Deprecated in iOS 10.3. Use subLocality and subAdministrativeArea on -postalAddress instead
     */
    @Deprecated
    @Property(selector = "supplementarySubLocality")
    public native String getSupplementarySubLocality();
    /**
     * @since Available in iOS 9.2 and later.
     * @deprecated Deprecated in iOS 10.3. Use subLocality and subAdministrativeArea on -postalAddress instead
     */
    @Deprecated
    @Property(selector = "setSupplementarySubLocality:")
    public native void setSupplementarySubLocality(String v);
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    
    /*</methods>*/
}
