/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.pencilkit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.uikit.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.coreanimation.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 13.0 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("PencilKit") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/PKDrawing/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*/implements NSSecureCoding/*</implements>*/ {

    /*<ptr>*/public static class PKDrawingPtr extends Ptr<PKDrawing, PKDrawingPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(PKDrawing.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public PKDrawing() {}
    protected PKDrawing(Handle h, long handle) { super(h, handle); }
    protected PKDrawing(SkipInit skipInit) { super(skipInit); }
    /**
     * @since Available in iOS 14.0 and later.
     */
    @Method(selector = "initWithStrokes:")
    public PKDrawing(NSArray<PKStroke> strokes) { super((SkipInit) null); initObject(init(strokes)); }
    @Method(selector = "initWithData:error:")
    public PKDrawing(NSData data) throws NSErrorException {
       super((SkipInit) null);
       NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
       long handle = init(data, ptr);
       if (ptr.get() != null) { throw new NSErrorException(ptr.get()); }
       initObject(handle);
    }
    @Method(selector = "initWithCoder:")
    public PKDrawing(NSCoder coder) { super((SkipInit) null); initObject(init(coder)); }
    /*</constructors>*/
    /*<properties>*/
    /**
     * @since Available in iOS 14.0 and later.
     */
    @Property(selector = "strokes")
    public native NSArray<PKStroke> getStrokes();
    @Property(selector = "bounds")
    public native @ByVal CGRect getBounds();
    @Property(selector = "supportsSecureCoding")
    public static native boolean supportsSecureCoding();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    /**
     * @since Available in iOS 13.0 and later.
     */
    @GlobalValue(symbol="PKAppleDrawingTypeIdentifier", optional=true)
    public static native String getAppleDrawingTypeIdentifier();
    
    /**
     * @since Available in iOS 14.0 and later.
     */
    @Method(selector = "initWithStrokes:")
    protected native @Pointer long init(NSArray<PKStroke> strokes);
    @Method(selector = "initWithData:error:")
    private native @Pointer long init(NSData data, NSError.NSErrorPtr error);
    @Method(selector = "dataRepresentation")
    public native NSData dataRepresentation();
    @Method(selector = "imageFromRect:scale:")
    public native UIImage getImageFromRect(@ByVal CGRect rect, @MachineSizedFloat double scale);
    @Method(selector = "drawingByApplyingTransform:")
    public native PKDrawing drawingByApplyingTransform(@ByVal CGAffineTransform transform);
    @Method(selector = "drawingByAppendingDrawing:")
    public native PKDrawing drawingByAppendingDrawing(PKDrawing drawing);
    /**
     * @since Available in iOS 14.0 and later.
     */
    @Method(selector = "drawingByAppendingStrokes:")
    public native PKDrawing drawingByAppendingStrokes(NSArray<PKStroke> strokes);
    @Method(selector = "encodeWithCoder:")
    public native void encode(NSCoder coder);
    @Method(selector = "initWithCoder:")
    protected native @Pointer long init(NSCoder coder);
    /*</methods>*/
}
