/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.scenekit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.uikit.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.coreanimation.*;
import org.robovm.apple.dispatch.*;
import org.robovm.apple.glkit.*;
import org.robovm.apple.spritekit.*;
import org.robovm.apple.opengles.*;
import org.robovm.apple.metal.*;
import org.robovm.apple.avfoundation.*;
/*</imports>*/

/*<javadoc>*/
/*</javadoc>*/
/*<annotations>*/@Library("SceneKit") @StronglyLinked/*</annotations>*/
@Marshaler(/*<name>*/SCNLightType/*</name>*/.Marshaler.class)
/*<visibility>*/public/*</visibility>*/ class /*<name>*/SCNLightType/*</name>*/ 
    extends /*<extends>*/GlobalValueEnumeration<NSString>/*</extends>*/
    /*<implements>*//*</implements>*/ {

    static { Bro.bind(/*<name>*/SCNLightType/*</name>*/.class); }

    /*<marshalers>*/
    public static class Marshaler {
        @MarshalsPointer
        public static SCNLightType toObject(Class<SCNLightType> cls, long handle, long flags) {
            NSString o = (NSString) NSObject.Marshaler.toObject(NSString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return SCNLightType.valueOf(o);
        }
        @MarshalsPointer
        public static long toNative(SCNLightType o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.value(), flags);
        }
    }
    public static class AsListMarshaler {
        @SuppressWarnings("unchecked")
        @MarshalsPointer
        public static List<SCNLightType> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray<NSString> o = (NSArray<NSString>) NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            List<SCNLightType> list = new ArrayList<>();
            for (int i = 0; i < o.size(); i++) {
                list.add(SCNLightType.valueOf(o.get(i)));
            }
            return list;
        }
        @MarshalsPointer
        public static long toNative(List<SCNLightType> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSArray<NSString> array = new NSMutableArray<>();
            for (SCNLightType o : l) {
                array.add(o.value());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }
    /*</marshalers>*/

    /*<constants>*/
    public static final SCNLightType Ambient = new SCNLightType("Ambient");
    public static final SCNLightType Omni = new SCNLightType("Omni");
    public static final SCNLightType Directional = new SCNLightType("Directional");
    public static final SCNLightType Spot = new SCNLightType("Spot");
    /**
     * @since Available in iOS 10.0 and later.
     */
    public static final SCNLightType IES = new SCNLightType("IES");
    /**
     * @since Available in iOS 10.0 and later.
     */
    public static final SCNLightType Probe = new SCNLightType("Probe");
    /**
     * @since Available in iOS 13.0 and later.
     */
    public static final SCNLightType Area = new SCNLightType("Area");
    /*</constants>*/
    
    private static /*<name>*/SCNLightType/*</name>*/[] values = new /*<name>*/SCNLightType/*</name>*/[] {/*<value_list>*/Ambient, Omni, Directional, Spot, IES, Probe, Area/*</value_list>*/};
    
    /*<name>*/SCNLightType/*</name>*/ (String getterName) {
        super(Values.class, getterName);
    }
    
    public static /*<name>*/SCNLightType/*</name>*/ valueOf(/*<type>*/NSString/*</type>*/ value) {
        for (/*<name>*/SCNLightType/*</name>*/ v : values) {
            if (v.value().equals(value)) {
                return v;
            }
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " 
            + /*<name>*/SCNLightType/*</name>*/.class.getName());
    }
    
    /*<methods>*//*</methods>*/
    
    /*<annotations>*/@Library("SceneKit") @StronglyLinked/*</annotations>*/
    public static class Values {
    	static { Bro.bind(Values.class); }

        /*<values>*/
        @GlobalValue(symbol="SCNLightTypeAmbient", optional=true)
        public static native NSString Ambient();
        @GlobalValue(symbol="SCNLightTypeOmni", optional=true)
        public static native NSString Omni();
        @GlobalValue(symbol="SCNLightTypeDirectional", optional=true)
        public static native NSString Directional();
        @GlobalValue(symbol="SCNLightTypeSpot", optional=true)
        public static native NSString Spot();
        /**
         * @since Available in iOS 10.0 and later.
         */
        @GlobalValue(symbol="SCNLightTypeIES", optional=true)
        public static native NSString IES();
        /**
         * @since Available in iOS 10.0 and later.
         */
        @GlobalValue(symbol="SCNLightTypeProbe", optional=true)
        public static native NSString Probe();
        /**
         * @since Available in iOS 13.0 and later.
         */
        @GlobalValue(symbol="SCNLightTypeArea", optional=true)
        public static native NSString Area();
        /*</values>*/
    }
}
