/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.scenekit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.uikit.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.coreanimation.*;
import org.robovm.apple.dispatch.*;
import org.robovm.apple.glkit.*;
import org.robovm.apple.spritekit.*;
import org.robovm.apple.opengles.*;
import org.robovm.apple.metal.*;
import org.robovm.apple.avfoundation.*;
/*</imports>*/

/*<javadoc>*/

/*</javadoc>*/
/*<annotations>*/@Library("SceneKit") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/SCNScene/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*/implements NSSecureCoding/*</implements>*/ {

    /*<ptr>*/public static class SCNScenePtr extends Ptr<SCNScene, SCNScenePtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(SCNScene.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public SCNScene() {}
    protected SCNScene(Handle h, long handle) { super(h, handle); }
    protected SCNScene(SkipInit skipInit) { super(skipInit); }
    @Method(selector = "initWithCoder:")
    public SCNScene(NSCoder coder) { super((SkipInit) null); initObject(init(coder)); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "rootNode")
    public native SCNNode getRootNode();
    @Property(selector = "physicsWorld")
    public native SCNPhysicsWorld getPhysicsWorld();
    @Property(selector = "background")
    public native SCNMaterialProperty getBackground();
    /**
     * @since Available in iOS 10.0 and later.
     */
    @Property(selector = "lightingEnvironment")
    public native SCNMaterialProperty getLightingEnvironment();
    @Property(selector = "fogStartDistance")
    public native @MachineSizedFloat double getFogStartDistance();
    @Property(selector = "setFogStartDistance:")
    public native void setFogStartDistance(@MachineSizedFloat double v);
    @Property(selector = "fogEndDistance")
    public native @MachineSizedFloat double getFogEndDistance();
    @Property(selector = "setFogEndDistance:")
    public native void setFogEndDistance(@MachineSizedFloat double v);
    @Property(selector = "fogDensityExponent")
    public native @MachineSizedFloat double getFogDensityExponent();
    @Property(selector = "setFogDensityExponent:")
    public native void setFogDensityExponent(@MachineSizedFloat double v);
    @Property(selector = "fogColor")
    public native UIColor getFogColor();
    @Property(selector = "setFogColor:")
    public native void setFogColor(UIColor v);
    /**
     * @since Available in iOS 13.0 and later.
     */
    @Property(selector = "wantsScreenSpaceReflection")
    public native boolean wantsScreenSpaceReflection();
    /**
     * @since Available in iOS 13.0 and later.
     */
    @Property(selector = "setWantsScreenSpaceReflection:")
    public native void setWantsScreenSpaceReflection(boolean v);
    /**
     * @since Available in iOS 13.0 and later.
     */
    @Property(selector = "screenSpaceReflectionSampleCount")
    public native @MachineSizedSInt long getScreenSpaceReflectionSampleCount();
    /**
     * @since Available in iOS 13.0 and later.
     */
    @Property(selector = "setScreenSpaceReflectionSampleCount:")
    public native void setScreenSpaceReflectionSampleCount(@MachineSizedSInt long v);
    /**
     * @since Available in iOS 13.0 and later.
     */
    @Property(selector = "screenSpaceReflectionMaximumDistance")
    public native @MachineSizedFloat double getScreenSpaceReflectionMaximumDistance();
    /**
     * @since Available in iOS 13.0 and later.
     */
    @Property(selector = "setScreenSpaceReflectionMaximumDistance:")
    public native void setScreenSpaceReflectionMaximumDistance(@MachineSizedFloat double v);
    /**
     * @since Available in iOS 13.0 and later.
     */
    @Property(selector = "screenSpaceReflectionStride")
    public native @MachineSizedFloat double getScreenSpaceReflectionStride();
    /**
     * @since Available in iOS 13.0 and later.
     */
    @Property(selector = "setScreenSpaceReflectionStride:")
    public native void setScreenSpaceReflectionStride(@MachineSizedFloat double v);
    @Property(selector = "isPaused")
    public native boolean isPaused();
    @Property(selector = "setPaused:")
    public native void setPaused(boolean v);
    @Property(selector = "particleSystems")
    public native NSArray<SCNParticleSystem> getParticleSystems();
    @Property(selector = "supportsSecureCoding")
    public static native boolean supportsSecureCoding();
    /*</properties>*/
    /*<members>*//*</members>*/
    public void setAttribute(SCNSceneAttribute key, NSObject attribute) {
        setAttribute(attribute, key);
    }
    
    /* Convenience methods */
    public double getStartTime() {
        NSNumber val = (NSNumber) getAttribute(SCNSceneAttribute.StartTime);
        if (val != null) {
            return val.doubleValue();
        }
        return 0;
    }
    public SCNScene setStartTime(double startTime) {
        setAttribute(NSNumber.valueOf(startTime), SCNSceneAttribute.StartTime);
        return this;
    }
    public double getEndTime() {
        NSNumber val = (NSNumber) getAttribute(SCNSceneAttribute.EndTime);
        if (val != null) {
            return val.doubleValue();
        }
        return 0;
    }
    public SCNScene setEndTime(double endTime) {
        setAttribute(NSNumber.valueOf(endTime), SCNSceneAttribute.EndTime);
        return this;
    }
    public double getFrameRate() {
        NSNumber val = (NSNumber) getAttribute(SCNSceneAttribute.FrameRate);
        if (val != null) {
            return val.doubleValue();
        }
        return 0;
    }
    public SCNScene setFrameRate(double frameRate) {
        setAttribute(NSNumber.valueOf(frameRate), SCNSceneAttribute.FrameRate);
        return this;
    }
    public SCNVector3 getUpAxis() {
        NSValue val = (NSValue) getAttribute(SCNSceneAttribute.UpAxis);
        if (val != null) {
            return val.SCNVector3Value();
        }
        return null;
    }
    public SCNScene setUpAxis(SCNVector3 upAxis) {
        setAttribute(NSValue.valueOf(upAxis), SCNSceneAttribute.UpAxis);
        return this;
    }
    /*<methods>*/
    @Method(selector = "attributeForKey:")
    public native NSObject getAttribute(SCNSceneAttribute key);
    @Method(selector = "setAttribute:forKey:")
    protected native void setAttribute(NSObject attribute, SCNSceneAttribute key);
    /**
     * @since Available in iOS 10.0 and later.
     */
    @Method(selector = "writeToURL:options:delegate:progressHandler:")
    public native boolean writeToURL(NSURL url, NSDictionary<NSString, ?> options, SCNSceneExportDelegate delegate, @Block VoidBlock3<Float, NSError, BooleanPtr> progressHandler);
    @Method(selector = "scene")
    public static native SCNScene create();
    @Method(selector = "sceneNamed:")
    public static native SCNScene create(String name);
    @Method(selector = "sceneNamed:inDirectory:options:")
    public static native SCNScene create(String name, String directory, SCNSceneSourceOptions options);
    public static SCNScene create(NSURL url, SCNSceneSourceOptions options) throws NSErrorException {
       NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
       SCNScene result = create(url, options, ptr);
       if (ptr.get() != null) { throw new NSErrorException(ptr.get()); }
       return result;
    }
    @Method(selector = "sceneWithURL:options:error:")
    private static native SCNScene create(NSURL url, SCNSceneSourceOptions options, NSError.NSErrorPtr error);
    @Method(selector = "addParticleSystem:withTransform:")
    public native void addParticleSystem(SCNParticleSystem system, @ByVal SCNMatrix4 transform);
    @Method(selector = "removeAllParticleSystems")
    public native void removeAllParticleSystems();
    @Method(selector = "removeParticleSystem:")
    public native void removeParticleSystem(SCNParticleSystem system);
    @Method(selector = "encodeWithCoder:")
    public native void encode(NSCoder coder);
    @Method(selector = "initWithCoder:")
    protected native @Pointer long init(NSCoder coder);
    /*</methods>*/
}
