/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.security;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corefoundation.*;
import org.robovm.apple.dispatch.*;
/*</imports>*/

/*<javadoc>*/
/*</javadoc>*/
/*<annotations>*/@Library("Security")/*</annotations>*/
@Marshaler(/*<name>*/SecQuery/*</name>*/.Marshaler.class)
/*<visibility>*/public/*</visibility>*/ class /*<name>*/SecQuery/*</name>*/ 
    extends /*<extends>*/CFDictionaryWrapper/*</extends>*/
    /*<implements>*//*</implements>*/ {

    /*<marshalers>*/
    public static class Marshaler {
        @MarshalsPointer
        public static SecQuery toObject(Class<SecQuery> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary) CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new SecQuery(o);
        }
        @MarshalsPointer
        public static long toNative(SecQuery o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<SecQuery> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray) CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            List<SecQuery> list = new ArrayList<>();
            for (int i = 0; i < o.size(); i++) {
                list.add(new SecQuery(o.get(i, CFDictionary.class)));
            }
            return list;
        }
        @MarshalsPointer
        public static long toNative(List<SecQuery> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFArray array = CFMutableArray.create();
            for (SecQuery i : l) {
                array.add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }
    /*</marshalers>*/

    /*<constructors>*/
    SecQuery(CFDictionary data) {
        super(data);
    }
    public SecQuery() {}
    /*</constructors>*/

    public SecQuery setAttributes(SecAttributes attributes) {
        data.putAll(attributes.getDictionary());
        return this;
    }
    public SecAttributes getAttributes() {
        return new SecAttributes(data);
    }
    public SecQuery setMatch(SecMatch match) {
        data.putAll(match.getDictionary());
        return this;
    }
    public SecMatch getMatch() {
        return new SecMatch(data);
    }
    public SecQuery setReturn(SecReturn returnOpts) {
        data.putAll(returnOpts.getDictionary());
        return this;
    }
    public SecReturn getReturn() {
        return new SecReturn(data);
    }
    public SecQuery setValue(SecValue value) {
        data.putAll(value.getDictionary());
        return this;
    }
    public SecValue getValue() {
        return new SecValue(data);
    }
    
    /*<methods>*/
    public boolean has(CFType key) {
        return data.containsKey(key);
    }
    public <T extends NativeObject> T get(CFType key, Class<T> type) {
        if (has(key)) {
            return data.get(key, type);
        }
        return null;
    }
    public SecQuery set(CFType key, NativeObject value) {
        data.put(key, value);
        return this;
    }
    

    public SecClass getClassType() {
        if (has(Keys.Class())) {
            CFType val = get(Keys.Class(), CFType.class);
            return SecClass.valueOf(val);
        }
        return null;
    }
    public SecQuery setClassType(SecClass classType) {
        set(Keys.Class(), classType.value());
        return this;
    }
    /*</methods>*/
    
    /*<keys>*/
    @Library("Security")
    public static class Keys {
        static { Bro.bind(Keys.class); }
        @GlobalValue(symbol="kSecClass", optional=true)
        public static native CFType Class();
    }
    /*</keys>*/
}
