/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.watchkit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.uikit.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.mapkit.*;
import org.robovm.apple.corelocation.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 8.2 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("WatchKit") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/WKUserNotificationInterfaceController/*</name>*/ 
    extends /*<extends>*/WKInterfaceController/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class WKUserNotificationInterfaceControllerPtr extends Ptr<WKUserNotificationInterfaceController, WKUserNotificationInterfaceControllerPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(WKUserNotificationInterfaceController.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public WKUserNotificationInterfaceController() {}
    protected WKUserNotificationInterfaceController(Handle h, long handle) { super(h, handle); }
    protected WKUserNotificationInterfaceController(SkipInit skipInit) { super(skipInit); }
    /*</constructors>*/
    /*<properties>*/
    
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    /**
     * @since Available in iOS 10.0 and later.
     */
    @Method(selector = "didReceiveNotification:withCompletion:")
    public native void didReceiveLocalNotification(org.robovm.apple.usernotifications.UNNotification notification, @Block VoidBlock1<WKUserNotificationInterfaceType> completionHandler);
    /**
     * @since Available in iOS 8.2 and later.
     * @deprecated Deprecated in iOS 10.0. use didReceiveNotification:withCompletion:
     */
    @Deprecated
    @Method(selector = "didReceiveRemoteNotification:withCompletion:")
    public native void didReceiveRemoteNotification(UIRemoteNotification remoteNotification, @Block VoidBlock1<WKUserNotificationInterfaceType> completionHandler);
    /**
     * @since Available in iOS 8.2 and later.
     * @deprecated Deprecated in iOS 10.0. use didReceiveNotification:withCompletion:
     */
    @Deprecated
    @Method(selector = "didReceiveLocalNotification:withCompletion:")
    public native void didReceiveLocalNotification(UILocalNotification localNotification, @Block VoidBlock1<WKUserNotificationInterfaceType> completionHandler);
    /*</methods>*/
}
