/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.audiotoolbox.AudioQueueBuffer;
import org.robovm.apple.audiotoolbox.AudioQueueParam;
import org.robovm.apple.audiotoolbox.AudioQueueParameterEvent;
import org.robovm.apple.audiotoolbox.AudioQueueProcessingTap;
import org.robovm.apple.audiotoolbox.AudioQueueProcessingTapFlags;
import org.robovm.apple.audiotoolbox.AudioQueueProperty;
import org.robovm.apple.audiotoolbox.AudioQueueTimeline;
import org.robovm.apple.coreaudio.AudioChannelLayout;
import org.robovm.apple.coreaudio.AudioStreamBasicDescription;
import org.robovm.apple.coreaudio.AudioStreamPacketDescription;
import org.robovm.apple.coreaudio.AudioTimeStamp;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.dispatch.DispatchQueue;
import org.robovm.apple.foundation.NSRunLoop;
import org.robovm.apple.foundation.NSRunLoopMode;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.LongMap;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.objc.block.VoidBlock5;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="AudioToolbox")
public class AudioQueue
extends NativeObject {
    private static AtomicLong callbackId = new AtomicLong();
    private static final LongMap<PropertyListener> propertyListeners = new LongMap();
    private static final Method cbPropertyChanged;
    private static final LongMap<InputCallback> inputCallbacks;
    private static final Method cbInput;
    private static final LongMap<OutputCallback> outputCallbacks;
    private static final Method cbOutput;

    protected AudioQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbPropertyChanged(@Pointer long userData, AudioQueue queue, AudioQueueProperty id) {
        LongMap<PropertyListener> longMap = propertyListeners;
        synchronized (longMap) {
            ((PropertyListener)propertyListeners.get(userData)).onChange(queue, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbInput(@Pointer long userData, AudioQueue queue, @Pointer long buffer, AudioTimeStamp startTime, int numberPacketDescs, AudioStreamPacketDescription packetDescs) {
        LongMap<InputCallback> longMap = inputCallbacks;
        synchronized (longMap) {
            ((InputCallback)inputCallbacks.get(userData)).onInput(queue, buffer, startTime, (AudioStreamPacketDescription[])packetDescs.toArray(numberPacketDescs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbOutput(@Pointer long userData, AudioQueue queue, @Pointer long buffer) {
        LongMap<OutputCallback> longMap = outputCallbacks;
        synchronized (longMap) {
            ((OutputCallback)outputCallbacks.get(userData)).onOutput(queue, buffer);
        }
    }

    public static AudioQueue createOutput(AudioStreamBasicDescription format, OutputCallback callback) throws OSStatusException {
        return AudioQueue.createOutput(format, callback, null, (String)null);
    }

    public static AudioQueue createOutput(AudioStreamBasicDescription format, OutputCallback callback, NSRunLoop callbackRunLoop, NSRunLoopMode callbackRunLoopMode) throws OSStatusException {
        return AudioQueue.createOutput(format, callback, callbackRunLoop, ((NSString)callbackRunLoopMode.value()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioQueue createOutput(AudioStreamBasicDescription format, OutputCallback callback, NSRunLoop callbackRunLoop, String callbackRunLoopMode) throws OSStatusException {
        AudioQueuePtr ptr;
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        long cid = callbackId.getAndIncrement();
        OSStatus status = AudioQueue.createOutput0(format, new FunctionPtr(cbOutput), cid, callbackRunLoop, callbackRunLoopMode, 0, ptr = new AudioQueuePtr());
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<OutputCallback> longMap = outputCallbacks;
            synchronized (longMap) {
                outputCallbacks.put(cid, (Object)callback);
            }
            return (AudioQueue)ptr.get();
        }
        return null;
    }

    public static AudioQueue createInput(AudioStreamBasicDescription format, InputCallback callback) throws OSStatusException {
        return AudioQueue.createInput(format, callback, null, (String)null);
    }

    public static AudioQueue createInput(AudioStreamBasicDescription format, InputCallback callback, NSRunLoop callbackRunLoop, NSRunLoopMode callbackRunLoopMode) throws OSStatusException {
        return AudioQueue.createInput(format, callback, callbackRunLoop, ((NSString)callbackRunLoopMode.value()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioQueue createInput(AudioStreamBasicDescription format, InputCallback callback, NSRunLoop callbackRunLoop, String callbackRunLoopMode) throws OSStatusException {
        AudioQueuePtr ptr;
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        long cid = callbackId.getAndIncrement();
        OSStatus status = AudioQueue.createInput0(format, new FunctionPtr(cbInput), cid, callbackRunLoop, callbackRunLoopMode, 0, ptr = new AudioQueuePtr());
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<InputCallback> longMap = inputCallbacks;
            synchronized (longMap) {
                inputCallbacks.put(cid, (Object)callback);
            }
            return (AudioQueue)ptr.get();
        }
        return null;
    }

    public void dispose(boolean immediate) throws OSStatusException {
        OSStatus status = this.dispose0(immediate);
        OSStatusException.throwIfNecessary(status);
    }

    public AudioQueueBuffer allocateBuffer(int bufferByteSize) throws OSStatusException {
        AudioQueueBuffer.AudioQueueBufferPtr ptr = new AudioQueueBuffer.AudioQueueBufferPtr();
        OSStatus status = this.allocateBuffer0(bufferByteSize, ptr);
        OSStatusException.throwIfNecessary(status);
        return (AudioQueueBuffer)ptr.get();
    }

    public AudioQueueBuffer allocateBuffer(int bufferByteSize, int numberPacketDescriptions) throws OSStatusException {
        AudioQueueBuffer.AudioQueueBufferPtr ptr = new AudioQueueBuffer.AudioQueueBufferPtr();
        OSStatus status = this.allocateBuffer0(bufferByteSize, numberPacketDescriptions, ptr);
        OSStatusException.throwIfNecessary(status);
        return (AudioQueueBuffer)ptr.get();
    }

    public void freeBuffer(AudioQueueBuffer buffer) throws OSStatusException {
        this.freeBuffer(buffer.getHandle());
    }

    public void freeBuffer(long buffer) throws OSStatusException {
        OSStatus status = this.freeBuffer0(buffer);
        OSStatusException.throwIfNecessary(status);
    }

    public void enqueueBuffer(AudioQueueBuffer buffer, AudioStreamPacketDescription[] packetDescs) throws OSStatusException {
        this.enqueueBuffer(buffer.getHandle(), packetDescs);
    }

    public void enqueueBuffer(long buffer, AudioStreamPacketDescription[] packetDescs) throws OSStatusException {
        AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr ptr = null;
        if (packetDescs != null) {
            ptr = new AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr();
            ptr.set((NativeObject[])packetDescs);
        }
        OSStatus status = this.enqueueBuffer0(buffer, packetDescs != null ? packetDescs.length : 0, ptr);
        OSStatusException.throwIfNecessary(status);
    }

    public AudioTimeStamp enqueueBuffer(AudioQueueBuffer buffer, AudioStreamPacketDescription[] packetDescs, int trimFramesAtStart, int trimFramesAtEnd, AudioQueueParameterEvent[] paramValues, AudioTimeStamp startTime) throws OSStatusException {
        return this.enqueueBuffer(buffer.getHandle(), packetDescs, trimFramesAtStart, trimFramesAtEnd, paramValues, startTime);
    }

    public AudioTimeStamp enqueueBuffer(long buffer, AudioStreamPacketDescription[] packetDescs, int trimFramesAtStart, int trimFramesAtEnd, AudioQueueParameterEvent[] paramValues, AudioTimeStamp startTime) throws OSStatusException {
        AudioTimeStamp.AudioTimeStampPtr ptr = new AudioTimeStamp.AudioTimeStampPtr();
        AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr packetDescsPtr = new AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr();
        packetDescsPtr.set((NativeObject[])packetDescs);
        AudioQueueParameterEvent.AudioQueueParameterEventPtr paramValuesPtr = new AudioQueueParameterEvent.AudioQueueParameterEventPtr();
        paramValuesPtr.set((NativeObject[])paramValues);
        OSStatus status = this.enqueueBuffer0(buffer, packetDescs.length, packetDescsPtr, trimFramesAtStart, trimFramesAtEnd, paramValues.length, paramValuesPtr, startTime, ptr);
        OSStatusException.throwIfNecessary(status);
        return (AudioTimeStamp)ptr.get();
    }

    public void start() throws OSStatusException {
        this.start(null);
    }

    public void start(AudioTimeStamp startTime) throws OSStatusException {
        OSStatus status = this.start0(startTime);
        OSStatusException.throwIfNecessary(status);
    }

    public int prime(int numberOfFramesToPrepare) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.prime0(numberOfFramesToPrepare, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public void stop(boolean immediate) throws OSStatusException {
        OSStatus status = this.stop0(immediate);
        OSStatusException.throwIfNecessary(status);
    }

    public void pause() throws OSStatusException {
        OSStatus status = this.pause0();
        OSStatusException.throwIfNecessary(status);
    }

    public void flush() throws OSStatusException {
        OSStatus status = this.flush0();
        OSStatusException.throwIfNecessary(status);
    }

    public void reset() throws OSStatusException {
        OSStatus status = this.reset0();
        OSStatusException.throwIfNecessary(status);
    }

    public float getParameter(AudioQueueParam param) throws OSStatusException {
        FloatPtr ptr = new FloatPtr();
        OSStatus status = this.getParameter0(param, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public void setParameter(AudioQueueParam param, float value) throws OSStatusException {
        OSStatus status = this.setParameter0(param, value);
        OSStatusException.throwIfNecessary(status);
    }

    public int getPropertySize(AudioQueueProperty id) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getPropertySize0(id, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public <T extends Struct<T>> T getProperty(AudioQueueProperty id, Class<T> type) throws OSStatusException {
        Struct data = Struct.allocate(type);
        IntPtr dataSize = new IntPtr(Struct.sizeOf((Struct)data));
        OSStatus status = this.getProperty0(id, (VoidPtr)data.as(VoidPtr.class), dataSize);
        OSStatusException.throwIfNecessary(status);
        return (T)data;
    }

    public <T extends Struct<T>> void setProperty(AudioQueueProperty id, T data) throws OSStatusException {
        OSStatus status = this.setProperty0(id, data == null ? null : (VoidPtr)data.as(VoidPtr.class), data == null ? 0 : Struct.sizeOf(data));
        OSStatusException.throwIfNecessary(status);
    }

    public int getPropertyAsInt(AudioQueueProperty id) throws OSStatusException {
        IntPtr ptr = this.getProperty(id, IntPtr.class);
        return ptr.get();
    }

    public long getPropertyAsLong(AudioQueueProperty id) throws OSStatusException {
        LongPtr ptr = this.getProperty(id, LongPtr.class);
        return ptr.get();
    }

    public float getPropertyAsFloat(AudioQueueProperty id) throws OSStatusException {
        FloatPtr ptr = this.getProperty(id, FloatPtr.class);
        return ptr.get();
    }

    public double getPropertyAsDouble(AudioQueueProperty id) throws OSStatusException {
        DoublePtr ptr = this.getProperty(id, DoublePtr.class);
        return ptr.get();
    }

    public void setProperty(AudioQueueProperty id, int value) throws OSStatusException {
        this.setProperty(id, new IntPtr(value));
    }

    public void setProperty(AudioQueueProperty id, long value) throws OSStatusException {
        this.setProperty(id, new LongPtr(value));
    }

    public void setProperty(AudioQueueProperty id, float value) throws OSStatusException {
        this.setProperty(id, new FloatPtr(value));
    }

    public void setProperty(AudioQueueProperty id, double value) throws OSStatusException {
        this.setProperty(id, new DoublePtr(value));
    }

    public boolean isRunning() throws OSStatusException {
        int result = this.getPropertyAsInt(AudioQueueProperty.IsRunning);
        return result != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyListener(AudioQueueProperty id, PropertyListener listener) throws OSStatusException {
        long cid = callbackId.getAndIncrement();
        OSStatus status = this.addPropertyListener0(id, new FunctionPtr(cbPropertyChanged), cid);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<PropertyListener> longMap = propertyListeners;
            synchronized (longMap) {
                propertyListeners.put(cid, (Object)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyListener(AudioQueueProperty id, PropertyListener listener) throws OSStatusException {
        LongMap<PropertyListener> longMap = propertyListeners;
        synchronized (longMap) {
            for (LongMap.Entry entry : propertyListeners.entries()) {
                if (entry.value != listener) continue;
                OSStatus status = this.removePropertyListener0(id, new FunctionPtr(cbPropertyChanged), entry.key);
                OSStatusException.throwIfNecessary(status);
            }
        }
    }

    public AudioQueueTimeline createTimeline() throws OSStatusException {
        AudioQueueTimeline.AudioQueueTimelinePtr ptr = new AudioQueueTimeline.AudioQueueTimelinePtr();
        OSStatus status = this.createTimeline0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (AudioQueueTimeline)ptr.get();
    }

    public void disposeTimeline(AudioQueueTimeline timeline) throws OSStatusException {
        OSStatus status = this.disposeTimeline0(timeline);
        OSStatusException.throwIfNecessary(status);
    }

    public AudioTimeStamp getCurrentTime(AudioQueueTimeline timeline) throws OSStatusException {
        AudioTimeStamp.AudioTimeStampPtr ptr = new AudioTimeStamp.AudioTimeStampPtr();
        OSStatus status = this.getCurrentTime0(timeline, ptr, null);
        OSStatusException.throwIfNecessary(status);
        return (AudioTimeStamp)ptr.get();
    }

    public AudioTimeStamp getCurrentDeviceTime() throws OSStatusException {
        AudioTimeStamp.AudioTimeStampPtr ptr = new AudioTimeStamp.AudioTimeStampPtr();
        OSStatus status = this.getCurrentDeviceTime0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (AudioTimeStamp)ptr.get();
    }

    public AudioTimeStamp translateDeviceTime(AudioTimeStamp time) throws OSStatusException {
        AudioTimeStamp.AudioTimeStampPtr ptr = new AudioTimeStamp.AudioTimeStampPtr();
        OSStatus status = this.translateDeviceTime0(time, ptr);
        OSStatusException.throwIfNecessary(status);
        return (AudioTimeStamp)ptr.get();
    }

    public AudioTimeStamp getNearestDeviceStartTime(AudioTimeStamp requestedStartTime) throws OSStatusException {
        OSStatus status = this.getNearestDeviceStartTime0(requestedStartTime, 0);
        OSStatusException.throwIfNecessary(status);
        return requestedStartTime;
    }

    public void setOfflineRenderFormat(AudioStreamBasicDescription format, AudioChannelLayout layout) throws OSStatusException {
        OSStatus status = this.setOfflineRenderFormat0(format, layout);
        OSStatusException.throwIfNecessary(status);
    }

    public AudioQueueBuffer offlineRender(AudioTimeStamp timestamp, AudioQueueBuffer buffer, int numberFrames) throws OSStatusException {
        OSStatus status = this.offlineRender0(timestamp, buffer, numberFrames);
        OSStatusException.throwIfNecessary(status);
        return buffer;
    }

    public AudioQueueProcessingTap createProcessingTap(AudioQueueProcessingTap.ProcessingTapCallback callback, AudioQueueProcessingTapFlags flags) throws OSStatusException {
        return AudioQueueProcessingTap.create(this, callback, flags);
    }

    @Bridge(symbol="AudioQueueNewOutput", optional=true)
    protected static native OSStatus createOutput0(AudioStreamBasicDescription var0, FunctionPtr var1, @Pointer long var2, NSRunLoop var4, String var5, int var6, AudioQueuePtr var7);

    @Bridge(symbol="AudioQueueNewInput", optional=true)
    protected static native OSStatus createInput0(AudioStreamBasicDescription var0, FunctionPtr var1, @Pointer long var2, NSRunLoop var4, String var5, int var6, AudioQueuePtr var7);

    @Bridge(symbol="AudioQueueNewOutputWithDispatchQueue", optional=true)
    protected static native OSStatus createOutputWithDispatchQueue0(AudioQueuePtr var0, AudioStreamBasicDescription var1, int var2, DispatchQueue var3, @Block VoidBlock2<AudioQueue, AudioQueueBuffer> var4);

    @Bridge(symbol="AudioQueueNewInputWithDispatchQueue", optional=true)
    protected static native OSStatus createInputWithDispatchQueue0(AudioQueuePtr var0, AudioStreamBasicDescription var1, int var2, DispatchQueue var3, @Block VoidBlock5<AudioQueue, AudioQueueBuffer, AudioTimeStamp, Integer, AudioStreamPacketDescription> var4);

    @Bridge(symbol="AudioQueueDispose", optional=true)
    protected native OSStatus dispose0(boolean var1);

    @Bridge(symbol="AudioQueueAllocateBuffer", optional=true)
    protected native OSStatus allocateBuffer0(int var1, AudioQueueBuffer.AudioQueueBufferPtr var2);

    @Bridge(symbol="AudioQueueAllocateBufferWithPacketDescriptions", optional=true)
    protected native OSStatus allocateBuffer0(int var1, int var2, AudioQueueBuffer.AudioQueueBufferPtr var3);

    @Bridge(symbol="AudioQueueFreeBuffer", optional=true)
    protected native OSStatus freeBuffer0(@Pointer long var1);

    @Bridge(symbol="AudioQueueEnqueueBuffer", optional=true)
    protected native OSStatus enqueueBuffer0(@Pointer long var1, int var3, AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr var4);

    @Bridge(symbol="AudioQueueEnqueueBufferWithParameters", optional=true)
    protected native OSStatus enqueueBuffer0(@Pointer long var1, int var3, AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr var4, int var5, int var6, int var7, AudioQueueParameterEvent.AudioQueueParameterEventPtr var8, AudioTimeStamp var9, AudioTimeStamp.AudioTimeStampPtr var10);

    @Bridge(symbol="AudioQueueStart", optional=true)
    protected native OSStatus start0(AudioTimeStamp var1);

    @Bridge(symbol="AudioQueuePrime", optional=true)
    protected native OSStatus prime0(int var1, IntPtr var2);

    @Bridge(symbol="AudioQueueStop", optional=true)
    protected native OSStatus stop0(boolean var1);

    @Bridge(symbol="AudioQueuePause", optional=true)
    protected native OSStatus pause0();

    @Bridge(symbol="AudioQueueFlush", optional=true)
    protected native OSStatus flush0();

    @Bridge(symbol="AudioQueueReset", optional=true)
    protected native OSStatus reset0();

    @Bridge(symbol="AudioQueueGetParameter", optional=true)
    protected native OSStatus getParameter0(AudioQueueParam var1, FloatPtr var2);

    @Bridge(symbol="AudioQueueSetParameter", optional=true)
    protected native OSStatus setParameter0(AudioQueueParam var1, float var2);

    @Bridge(symbol="AudioQueueGetProperty", optional=true)
    protected native OSStatus getProperty0(AudioQueueProperty var1, VoidPtr var2, IntPtr var3);

    @Bridge(symbol="AudioQueueSetProperty", optional=true)
    protected native OSStatus setProperty0(AudioQueueProperty var1, VoidPtr var2, int var3);

    @Bridge(symbol="AudioQueueGetPropertySize", optional=true)
    protected native OSStatus getPropertySize0(AudioQueueProperty var1, IntPtr var2);

    @Bridge(symbol="AudioQueueAddPropertyListener", optional=true)
    protected native OSStatus addPropertyListener0(AudioQueueProperty var1, FunctionPtr var2, @Pointer long var3);

    @Bridge(symbol="AudioQueueRemovePropertyListener", optional=true)
    protected native OSStatus removePropertyListener0(AudioQueueProperty var1, FunctionPtr var2, @Pointer long var3);

    @Bridge(symbol="AudioQueueCreateTimeline", optional=true)
    protected native OSStatus createTimeline0(AudioQueueTimeline.AudioQueueTimelinePtr var1);

    @Bridge(symbol="AudioQueueDisposeTimeline", optional=true)
    protected native OSStatus disposeTimeline0(AudioQueueTimeline var1);

    @Bridge(symbol="AudioQueueGetCurrentTime", optional=true)
    protected native OSStatus getCurrentTime0(AudioQueueTimeline var1, AudioTimeStamp.AudioTimeStampPtr var2, BooleanPtr var3);

    @Bridge(symbol="AudioQueueDeviceGetCurrentTime", optional=true)
    protected native OSStatus getCurrentDeviceTime0(AudioTimeStamp.AudioTimeStampPtr var1);

    @Bridge(symbol="AudioQueueDeviceTranslateTime", optional=true)
    protected native OSStatus translateDeviceTime0(AudioTimeStamp var1, AudioTimeStamp.AudioTimeStampPtr var2);

    @Bridge(symbol="AudioQueueDeviceGetNearestStartTime", optional=true)
    protected native OSStatus getNearestDeviceStartTime0(AudioTimeStamp var1, int var2);

    @Bridge(symbol="AudioQueueSetOfflineRenderFormat", optional=true)
    protected native OSStatus setOfflineRenderFormat0(AudioStreamBasicDescription var1, AudioChannelLayout var2);

    @Bridge(symbol="AudioQueueOfflineRender", optional=true)
    protected native OSStatus offlineRender0(AudioTimeStamp var1, AudioQueueBuffer var2, int var3);

    static {
        inputCallbacks = new LongMap();
        outputCallbacks = new LongMap();
        try {
            cbPropertyChanged = AudioQueue.class.getDeclaredMethod("cbPropertyChanged", Long.TYPE, AudioQueue.class, AudioQueueProperty.class);
            cbInput = AudioQueue.class.getDeclaredMethod("cbInput", Long.TYPE, AudioQueue.class, Long.TYPE, AudioTimeStamp.class, Integer.TYPE, AudioStreamPacketDescription.class);
            cbOutput = AudioQueue.class.getDeclaredMethod("cbOutput", Long.TYPE, AudioQueue.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(AudioQueue.class);
    }

    public static interface PropertyListener {
        public void onChange(AudioQueue var1, AudioQueueProperty var2);
    }

    public static interface InputCallback {
        public void onInput(AudioQueue var1, long var2, AudioTimeStamp var4, AudioStreamPacketDescription[] var5);
    }

    public static interface OutputCallback {
        public void onOutput(AudioQueue var1, long var2);
    }

    public static class AudioQueuePtr
    extends Ptr<AudioQueue, AudioQueuePtr> {
    }
}

