/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.cloudkit;

import org.robovm.apple.cloudkit.CKAccountStatus;
import org.robovm.apple.cloudkit.CKApplicationPermissionStatus;
import org.robovm.apple.cloudkit.CKApplicationPermissions;
import org.robovm.apple.cloudkit.CKDatabase;
import org.robovm.apple.cloudkit.CKDatabaseScope;
import org.robovm.apple.cloudkit.CKOperation;
import org.robovm.apple.cloudkit.CKRecordID;
import org.robovm.apple.cloudkit.CKShare;
import org.robovm.apple.cloudkit.CKShareMetadata;
import org.robovm.apple.cloudkit.CKShareParticipant;
import org.robovm.apple.cloudkit.CKUserIdentity;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CloudKit")
@NativeClass
public class CKContainer
extends NSObject {
    protected CKContainer() {
    }

    protected CKContainer(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected CKContainer(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public CKContainer(String containerIdentifier) {
        super(null, CKContainer.create(containerIdentifier));
        CKContainer.retain(this.getHandle());
    }

    @Property(selector="containerIdentifier")
    public native String getContainerIdentifier();

    @Property(selector="privateCloudDatabase")
    public native CKDatabase getPrivateCloudDatabase();

    @Property(selector="publicCloudDatabase")
    public native CKDatabase getPublicCloudDatabase();

    @Property(selector="sharedCloudDatabase")
    public native CKDatabase getSharedCloudDatabase();

    @GlobalValue(symbol="CKCurrentUserDefaultName", optional=true)
    public static native String getDefaultCurrentUserName();

    @Deprecated
    @GlobalValue(symbol="CKOwnerDefaultName", optional=true)
    public static native String getDefaultOwnerName();

    @GlobalValue(symbol="CKAccountChangedNotification", optional=true)
    public static native NSString AccountChangedNotification();

    @Method(selector="addOperation:")
    public native void addOperation(CKOperation var1);

    @Method(selector="defaultContainer")
    public static native CKContainer getDefaultContainer();

    @Method(selector="containerWithIdentifier:")
    @Pointer
    protected static native long create(String var0);

    @Method(selector="databaseWithDatabaseScope:")
    public native CKDatabase getDatanase(CKDatabaseScope var1);

    @Method(selector="accountStatusWithCompletionHandler:")
    public native void getAccountStatus(@Block VoidBlock2<CKAccountStatus, NSError> var1);

    @Method(selector="statusForApplicationPermission:completionHandler:")
    public native void getStatusForApplicationPermission(CKApplicationPermissions var1, @Block VoidBlock2<CKApplicationPermissionStatus, NSError> var2);

    @Method(selector="requestApplicationPermission:completionHandler:")
    public native void requestApplicationPermission(CKApplicationPermissions var1, @Block VoidBlock2<CKApplicationPermissionStatus, NSError> var2);

    @Method(selector="fetchUserRecordIDWithCompletionHandler:")
    public native void fetchUserRecordID(@Block VoidBlock2<CKRecordID, NSError> var1);

    @Method(selector="discoverAllIdentitiesWithCompletionHandler:")
    public native void discoverAllIdentities(@Block VoidBlock2<NSArray<CKUserIdentity>, NSError> var1);

    @Method(selector="discoverUserIdentityWithEmailAddress:completionHandler:")
    public native void discoverUserIdentityWithEmailAddress(String var1, @Block VoidBlock2<CKUserIdentity, NSError> var2);

    @Method(selector="discoverUserIdentityWithPhoneNumber:completionHandler:")
    public native void discoverUserIdentityWithPhoneNumber(String var1, @Block VoidBlock2<CKUserIdentity, NSError> var2);

    @Method(selector="discoverUserIdentityWithUserRecordID:completionHandler:")
    public native void discoverUserIdentityWithUserRecordID(CKRecordID var1, @Block VoidBlock2<CKUserIdentity, NSError> var2);

    @Method(selector="fetchShareParticipantWithEmailAddress:completionHandler:")
    public native void fetchShareParticipantWithEmailAddress(String var1, @Block VoidBlock2<CKShareParticipant, NSError> var2);

    @Method(selector="fetchShareParticipantWithPhoneNumber:completionHandler:")
    public native void fetchShareParticipantWithPhoneNumber(String var1, @Block VoidBlock2<CKShareParticipant, NSError> var2);

    @Method(selector="fetchShareParticipantWithUserRecordID:completionHandler:")
    public native void fetchShareParticipantWithUserRecordID(CKRecordID var1, @Block VoidBlock2<CKShareParticipant, NSError> var2);

    @Method(selector="fetchShareMetadataWithURL:completionHandler:")
    public native void fetchShareMetadata(NSURL var1, @Block VoidBlock2<CKShareMetadata, NSError> var2);

    @Method(selector="acceptShareMetadata:completionHandler:")
    public native void acceptShareMetadata(CKShareMetadata var1, @Block VoidBlock2<CKShare, NSError> var2);

    @Method(selector="fetchAllLongLivedOperationIDsWithCompletionHandler:")
    public native void fetchAllLongLivedOperationIDs(@Block VoidBlock2<NSArray<NSString>, NSError> var1);

    @Method(selector="fetchLongLivedOperationWithID:completionHandler:")
    public native void fetchLongLivedOperation(String var1, @Block VoidBlock2<CKOperation, NSError> var2);

    static {
        ObjCRuntime.bind(CKContainer.class);
    }

    public static class CKContainerPtr
    extends Ptr<CKContainer, CKContainerPtr> {
    }

    public static class Notifications {
        public static NSObjectProtocol observeAccountChanged(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(CKContainer.AccountChangedNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

