/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coredata;

import org.robovm.apple.coredata.NSManagedObjectContext;
import org.robovm.apple.coredata.NSManagedObjectID;
import org.robovm.apple.coredata.NSManagedObjectModel;
import org.robovm.apple.coredata.NSPersistentHistoryToken;
import org.robovm.apple.coredata.NSPersistentStore;
import org.robovm.apple.coredata.NSPersistentStoreCoordinatorChangeNotification;
import org.robovm.apple.coredata.NSPersistentStoreDescription;
import org.robovm.apple.coredata.NSPersistentStoreMetadata;
import org.robovm.apple.coredata.NSPersistentStoreOptions;
import org.robovm.apple.coredata.NSPersistentStoreRequest;
import org.robovm.apple.coredata.NSPersistentStoreType;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSLocking;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreData")
@NativeClass
public class NSPersistentStoreCoordinator
extends NSObject
implements NSLocking {
    public NSPersistentStoreCoordinator() {
    }

    protected NSPersistentStoreCoordinator(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSPersistentStoreCoordinator(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithManagedObjectModel:")
    public NSPersistentStoreCoordinator(NSManagedObjectModel model) {
        super(null);
        this.initObject(this.init(model));
    }

    @Property(selector="managedObjectModel")
    public native NSManagedObjectModel getManagedObjectModel();

    @Property(selector="persistentStores")
    public native NSArray<NSPersistentStore> getPersistentStores();

    @Property(selector="name")
    public native String getName();

    @Property(selector="setName:")
    public native void setName(String var1);

    @Property(selector="registeredStoreTypes")
    public static native NSDictionary<NSString, NSPersistentStore> getRegisteredStoreTypes();

    public NSPersistentStore addPersistentStore(NSPersistentStoreType storeType, String configuration, NSURL storeURL, NSPersistentStoreOptions options) throws NSErrorException {
        return this.addPersistentStore(((NSString)storeType.value()).toString(), configuration, storeURL, options);
    }

    public NSPersistentStore migratePersistentStore(NSPersistentStore store, NSURL URL2, NSPersistentStoreOptions options, NSPersistentStoreType storeType) throws NSErrorException {
        return this.migratePersistentStore(store, URL2, options, ((NSString)storeType.value()).toString());
    }

    public static void registerStoreClassForType(Class<? extends NSPersistentStore> storeClass, NSPersistentStoreType storeType) {
        NSPersistentStoreCoordinator.registerStoreClassForType(storeClass, ((NSString)storeType.value()).toString());
    }

    public static NSPersistentStoreMetadata getMetadataForPersistentStoreType(NSPersistentStoreType storeType, NSURL url) throws NSErrorException {
        return NSPersistentStoreCoordinator.getMetadataForPersistentStoreType(((NSString)storeType.value()).toString(), url);
    }

    public static boolean setMetadataForPersistentStoreType(NSPersistentStoreMetadata metadata, NSPersistentStoreType storeType, NSURL url) throws NSErrorException {
        return NSPersistentStoreCoordinator.setMetadataForPersistentStoreType(metadata, ((NSString)storeType.value()).toString(), url);
    }

    @GlobalValue(symbol="NSCoreDataCoreSpotlightExporter", optional=true)
    public static native String CoreSpotlightExporter();

    @Method(selector="initWithManagedObjectModel:")
    @Pointer
    protected native long init(NSManagedObjectModel var1);

    @Method(selector="persistentStoreForURL:")
    public native NSPersistentStore getPersistentStoreForURL(NSURL var1);

    @Method(selector="URLForPersistentStore:")
    public native NSURL getURLForPersistentStore(NSPersistentStore var1);

    @Method(selector="setURL:forPersistentStore:")
    public native boolean setURLForPersistentStore(NSURL var1, NSPersistentStore var2);

    public NSPersistentStore addPersistentStore(String storeType, String configuration, NSURL storeURL, NSPersistentStoreOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSPersistentStore result = this.addPersistentStore(storeType, configuration, storeURL, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="addPersistentStoreWithType:configuration:URL:options:error:")
    private native NSPersistentStore addPersistentStore(String var1, String var2, NSURL var3, NSPersistentStoreOptions var4, NSError.NSErrorPtr var5);

    @Method(selector="addPersistentStoreWithDescription:completionHandler:")
    public native void addPersistentStoreWithDescription(NSPersistentStoreDescription var1, @Block VoidBlock2<NSPersistentStoreDescription, NSError> var2);

    public boolean removePersistentStore(NSPersistentStore store) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.removePersistentStore(store, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="removePersistentStore:error:")
    private native boolean removePersistentStore(NSPersistentStore var1, NSError.NSErrorPtr var2);

    @Method(selector="setMetadata:forPersistentStore:")
    public native void setMetadataForPersistentStore(NSPersistentStoreMetadata var1, NSPersistentStore var2);

    @Method(selector="metadataForPersistentStore:")
    public native NSDictionary<NSString, ?> getMetadataForPersistentStore(NSPersistentStore var1);

    @Method(selector="managedObjectIDForURIRepresentation:")
    public native NSManagedObjectID getManagedObjectIDForURIRepresentation(NSURL var1);

    public NSObject executeRequest(NSPersistentStoreRequest request, NSManagedObjectContext context) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSObject result = this.executeRequest(request, context, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="executeRequest:withContext:error:")
    private native NSObject executeRequest(NSPersistentStoreRequest var1, NSManagedObjectContext var2, NSError.NSErrorPtr var3);

    public NSPersistentStore migratePersistentStore(NSPersistentStore store, NSURL URL2, NSPersistentStoreOptions options, String storeType) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSPersistentStore result = this.migratePersistentStore(store, URL2, options, storeType, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="migratePersistentStore:toURL:options:withType:error:")
    private native NSPersistentStore migratePersistentStore(NSPersistentStore var1, NSURL var2, NSPersistentStoreOptions var3, String var4, NSError.NSErrorPtr var5);

    public boolean destroyPersistentStore(NSURL url, String storeType, NSPersistentStoreOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.destroyPersistentStore(url, storeType, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="destroyPersistentStoreAtURL:withType:options:error:")
    private native boolean destroyPersistentStore(NSURL var1, String var2, NSPersistentStoreOptions var3, NSError.NSErrorPtr var4);

    public boolean replacePersistentStore(NSURL destinationURL, NSPersistentStoreOptions destinationOptions, NSURL sourceURL, NSPersistentStoreOptions sourceOptions, String storeType) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.replacePersistentStore(destinationURL, destinationOptions, sourceURL, sourceOptions, storeType, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="replacePersistentStoreAtURL:destinationOptions:withPersistentStoreFromURL:sourceOptions:storeType:error:")
    private native boolean replacePersistentStore(NSURL var1, NSPersistentStoreOptions var2, NSURL var3, NSPersistentStoreOptions var4, String var5, NSError.NSErrorPtr var6);

    @Method(selector="performBlock:")
    public native void performBlock(@Block Runnable var1);

    @Method(selector="performBlockAndWait:")
    public native void performBlockAndWait(@Block Runnable var1);

    @Method(selector="currentPersistentHistoryTokenFromStores:")
    public native NSPersistentHistoryToken currentPersistentHistoryTokenFromStores(NSArray<?> var1);

    @Override
    @Deprecated
    @Method(selector="lock")
    public native void lock();

    @Override
    @Deprecated
    @Method(selector="unlock")
    public native void unlock();

    @Deprecated
    @Method(selector="tryLock")
    public native boolean tryLock();

    @Method(selector="registerStoreClass:forStoreType:")
    public static native void registerStoreClassForType(Class<? extends NSPersistentStore> var0, String var1);

    public static NSPersistentStoreMetadata getMetadataForPersistentStoreType(String storeType, NSURL url, NSPersistentStoreOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSPersistentStoreMetadata result = NSPersistentStoreCoordinator.getMetadataForPersistentStoreType(storeType, url, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="metadataForPersistentStoreOfType:URL:options:error:")
    private static native NSPersistentStoreMetadata getMetadataForPersistentStoreType(String var0, NSURL var1, NSPersistentStoreOptions var2, NSError.NSErrorPtr var3);

    public static boolean setMetadataForPersistentStoreType(NSPersistentStoreMetadata metadata, String storeType, NSURL url, NSPersistentStoreOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = NSPersistentStoreCoordinator.setMetadataForPersistentStoreType(metadata, storeType, url, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setMetadata:forPersistentStoreOfType:URL:options:error:")
    private static native boolean setMetadataForPersistentStoreType(NSPersistentStoreMetadata var0, String var1, NSURL var2, NSPersistentStoreOptions var3, NSError.NSErrorPtr var4);

    @Deprecated
    public static NSPersistentStoreMetadata getMetadataForPersistentStoreType(String storeType, NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSPersistentStoreMetadata result = NSPersistentStoreCoordinator.getMetadataForPersistentStoreType(storeType, url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Deprecated
    @Method(selector="metadataForPersistentStoreOfType:URL:error:")
    private static native NSPersistentStoreMetadata getMetadataForPersistentStoreType(String var0, NSURL var1, NSError.NSErrorPtr var2);

    @Deprecated
    public static boolean setMetadataForPersistentStoreType(NSPersistentStoreMetadata metadata, String storeType, NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = NSPersistentStoreCoordinator.setMetadataForPersistentStoreType(metadata, storeType, url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Deprecated
    @Method(selector="setMetadata:forPersistentStoreOfType:URL:error:")
    private static native boolean setMetadataForPersistentStoreType(NSPersistentStoreMetadata var0, String var1, NSURL var2, NSError.NSErrorPtr var3);

    @Deprecated
    public static boolean removeUbiquitousContentAndPersistentStore(NSURL storeURL, NSPersistentStoreOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = NSPersistentStoreCoordinator.removeUbiquitousContentAndPersistentStore(storeURL, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Deprecated
    @Method(selector="removeUbiquitousContentAndPersistentStoreAtURL:options:error:")
    private static native boolean removeUbiquitousContentAndPersistentStore(NSURL var0, NSPersistentStoreOptions var1, NSError.NSErrorPtr var2);

    static {
        ObjCRuntime.bind(NSPersistentStoreCoordinator.class);
    }

    @Library(value="CoreData")
    public static class NotificationKeys {
        @GlobalValue(symbol="NSPersistentStoreCoordinatorStoresWillChangeNotification", optional=true)
        public static native NSString CoordinatorStoresWillChange();

        @GlobalValue(symbol="NSPersistentStoreCoordinatorStoresDidChangeNotification", optional=true)
        public static native NSString CoordinatorStoresDidChange();

        @GlobalValue(symbol="NSPersistentStoreCoordinatorWillRemoveStoreNotification", optional=true)
        public static native NSString CoordinatorWillRemoveStore();

        @GlobalValue(symbol="NSPersistentStoreRemoteChangeNotification", optional=true)
        public static native NSString RemoteChange();

        @Deprecated
        @GlobalValue(symbol="NSPersistentStoreDidImportUbiquitousContentChangesNotification", optional=true)
        public static native NSString DidImportUbiquitousContentChanges();

        static {
            Bro.bind(NotificationKeys.class);
        }
    }

    public static class NSPersistentStoreCoordinatorPtr
    extends Ptr<NSPersistentStoreCoordinator, NSPersistentStoreCoordinatorPtr> {
    }

    public static class Notifications {
        public static NSObjectProtocol observeStoresWillChange(NSPersistentStoreCoordinator object, final VoidBlock2<NSPersistentStoreCoordinator, NSPersistentStoreCoordinatorChangeNotification> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NotificationKeys.CoordinatorStoresWillChange(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<?, ?> userInfo = a.getUserInfo();
                    NSPersistentStoreCoordinatorChangeNotification data = null;
                    if (userInfo != null) {
                        data = new NSPersistentStoreCoordinatorChangeNotification(userInfo);
                    }
                    block.invoke((Object)((NSPersistentStoreCoordinator)a.getObject()), (Object)data);
                }
            });
        }

        public static NSObjectProtocol observeStoresDidChange(NSPersistentStoreCoordinator object, final VoidBlock2<NSPersistentStoreCoordinator, NSPersistentStoreCoordinatorChangeNotification> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NotificationKeys.CoordinatorStoresDidChange(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<?, ?> userInfo = a.getUserInfo();
                    NSPersistentStoreCoordinatorChangeNotification data = null;
                    if (userInfo != null) {
                        data = new NSPersistentStoreCoordinatorChangeNotification(userInfo);
                    }
                    block.invoke((Object)((NSPersistentStoreCoordinator)a.getObject()), (Object)data);
                }
            });
        }

        public static NSObjectProtocol observeWillRemoveStore(NSPersistentStoreCoordinator object, final VoidBlock1<NSPersistentStoreCoordinator> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NotificationKeys.CoordinatorWillRemoveStore(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSPersistentStoreCoordinator)a.getObject()));
                }
            });
        }

        public static NSObjectProtocol observeDidImportUbiquitousContentChanges(NSPersistentStoreCoordinator object, final VoidBlock2<NSPersistentStoreCoordinator, NSNotification> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NotificationKeys.DidImportUbiquitousContentChanges(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSPersistentStoreCoordinator)a.getObject()), (Object)a);
                }
            });
        }
    }
}

