/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.util.List;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFLocaleComponent;
import org.robovm.apple.corefoundation.CFLocaleComponents;
import org.robovm.apple.corefoundation.CFLocaleLanguageDirection;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public class CFLocale
extends CFType {
    protected CFLocale() {
    }

    public static String getCanonicalLanguageIdentifier(String localeIdentifier) {
        return CFLocale.getCanonicalLanguageIdentifier(null, localeIdentifier);
    }

    public static String getCanonicalLocaleIdentifier(String localeIdentifier) {
        return CFLocale.getCanonicalLocaleIdentifier(null, localeIdentifier);
    }

    public static String getCanonicalLocaleIdentifier(short lcode, short rcode) {
        return CFLocale.getCanonicalLocaleIdentifier(null, lcode, rcode);
    }

    public static String getLocaleIdentifierFromWindowsLocaleCode(int lcid) {
        return CFLocale.getLocaleIdentifierFromWindowsLocaleCode(null, lcid);
    }

    public static CFLocaleComponents getComponentsFromLocaleIdentifier(String localeID) {
        return CFLocale.getComponentsFromLocaleIdentifier(null, localeID);
    }

    public static String getLocaleIdentifierFromComponents(CFLocaleComponents components) {
        return CFLocale.getLocaleIdentifierFromComponents(null, components);
    }

    public static CFLocale create(String localeIdentifier) {
        return CFLocale.create(null, localeIdentifier);
    }

    public static CFLocale createCopy(CFLocale locale) {
        return CFLocale.createCopy(null, locale);
    }

    @GlobalValue(symbol="kCFLocaleCurrentLocaleDidChangeNotification", optional=true)
    public static native NSString CurrentLocaleDidChangeNotification();

    @Bridge(symbol="CFLocaleGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFLocaleGetSystem", optional=true)
    public static native CFLocale getSystem();

    @Bridge(symbol="CFLocaleCopyCurrent", optional=true)
    public static native CFLocale getCurrent();

    @Bridge(symbol="CFLocaleCopyAvailableLocaleIdentifiers", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    public static native List<String> getAvailableLocaleIdentifiers();

    @Bridge(symbol="CFLocaleCopyISOLanguageCodes", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    public static native List<String> getISOLanguageCodes();

    @Bridge(symbol="CFLocaleCopyISOCountryCodes", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    public static native List<String> getISOCountryCodes();

    @Bridge(symbol="CFLocaleCopyISOCurrencyCodes", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    public static native List<String> getISOCurrencyCodes();

    @Bridge(symbol="CFLocaleCopyCommonISOCurrencyCodes", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    public static native List<String> getCommonISOCurrencyCodes();

    @Bridge(symbol="CFLocaleCopyPreferredLanguages", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    public static native List<String> getPreferredLanguages();

    @Bridge(symbol="CFLocaleCreateCanonicalLanguageIdentifierFromString", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    protected static native String getCanonicalLanguageIdentifier(CFAllocator var0, String var1);

    @Bridge(symbol="CFLocaleCreateCanonicalLocaleIdentifierFromString", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    protected static native String getCanonicalLocaleIdentifier(CFAllocator var0, String var1);

    @Bridge(symbol="CFLocaleCreateCanonicalLocaleIdentifierFromScriptManagerCodes", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    protected static native String getCanonicalLocaleIdentifier(CFAllocator var0, short var1, short var2);

    @Bridge(symbol="CFLocaleCreateLocaleIdentifierFromWindowsLocaleCode", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    protected static native String getLocaleIdentifierFromWindowsLocaleCode(CFAllocator var0, int var1);

    @Bridge(symbol="CFLocaleGetWindowsLocaleCodeFromLocaleIdentifier", optional=true)
    public static native int getWindowsLocaleCodeFromLocaleIdentifier(String var0);

    @Bridge(symbol="CFLocaleGetLanguageCharacterDirection", optional=true)
    public static native CFLocaleLanguageDirection getLanguageCharacterDirection(String var0);

    @Bridge(symbol="CFLocaleGetLanguageLineDirection", optional=true)
    public static native CFLocaleLanguageDirection getLanguageLineDirection(String var0);

    @Bridge(symbol="CFLocaleCreateComponentsFromLocaleIdentifier", optional=true)
    protected static native CFLocaleComponents getComponentsFromLocaleIdentifier(CFAllocator var0, String var1);

    @Bridge(symbol="CFLocaleCreateLocaleIdentifierFromComponents", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    protected static native String getLocaleIdentifierFromComponents(CFAllocator var0, CFLocaleComponents var1);

    @Bridge(symbol="CFLocaleCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFLocale create(CFAllocator var0, String var1);

    @Bridge(symbol="CFLocaleCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFLocale createCopy(CFAllocator var0, CFLocale var1);

    @Bridge(symbol="CFLocaleGetIdentifier", optional=true)
    public native String getIdentifier();

    @Bridge(symbol="CFLocaleGetValue", optional=true)
    public native CFType getComponent(CFLocaleComponent var1);

    @Bridge(symbol="CFLocaleCopyDisplayNameForPropertyValue", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getComponentDisplayName(CFLocaleComponent var1, String var2);

    static {
        Bro.bind(CFLocale.class);
    }

    public static class CFLocalePtr
    extends Ptr<CFLocale, CFLocalePtr> {
    }

    public static class Notifications {
        public static NSObjectProtocol observeCurrentLocaleDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(CFLocale.CurrentLocaleDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

