/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFData;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFStringEncodings;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.CFURLPathStyle;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreFoundation")
public class CFURL
extends CFType {
    protected CFURL() {
    }

    @Bridge(symbol="CFURLGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFURLCreateWithBytes", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFURL create(CFAllocator var0, BytePtr var1, @MachineSizedSInt long var2, CFStringEncodings var4, CFURL var5);

    @Bridge(symbol="CFURLCreateData", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFData asData(CFAllocator var0, CFURL var1, CFStringEncodings var2, boolean var3);

    @Bridge(symbol="CFURLCreateWithString", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFURL create(CFAllocator var0, String var1, CFURL var2);

    @Bridge(symbol="CFURLCreateAbsoluteURLWithBytes", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFURL create(CFAllocator var0, BytePtr var1, @MachineSizedSInt long var2, CFStringEncodings var4, CFURL var5, boolean var6);

    @Bridge(symbol="CFURLCreateWithFileSystemPath", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFURL createWithFileSystemPath(CFAllocator var0, String var1, CFURLPathStyle var2, boolean var3);

    @Bridge(symbol="CFURLCreateFromFileSystemRepresentation", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFURL createFromFileSystemRepresentation(CFAllocator var0, BytePtr var1, @MachineSizedSInt long var2, boolean var4);

    @Bridge(symbol="CFURLCreateWithFileSystemPathRelativeToBase", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFURL createWithFileSystemPathRelativeToBase(CFAllocator var0, String var1, CFURLPathStyle var2, boolean var3, CFURL var4);

    @Bridge(symbol="CFURLCreateFromFileSystemRepresentationRelativeToBase", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFURL createFromFileSystemRepresentationRelativeToBase(CFAllocator var0, BytePtr var1, @MachineSizedSInt long var2, boolean var4, CFURL var5);

    @Bridge(symbol="CFURLCopyAbsoluteURL", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CFURL getAbsoluteURL();

    @Bridge(symbol="CFURLGetString", optional=true)
    public native String getString();

    @Bridge(symbol="CFURLGetBaseURL", optional=true)
    public native CFURL getBaseURL();

    @Bridge(symbol="CFURLCanBeDecomposed", optional=true)
    public native boolean canBeDecomposed();

    @Bridge(symbol="CFURLCopyScheme", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getScheme();

    @Bridge(symbol="CFURLCopyNetLocation", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getNetLocation();

    @Bridge(symbol="CFURLCopyPath", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getPath();

    @Bridge(symbol="CFURLCopyStrictPath", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getStrictPath(BooleanPtr var1);

    @Bridge(symbol="CFURLCopyFileSystemPath", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getFileSystemPath(CFURLPathStyle var1);

    @Bridge(symbol="CFURLHasDirectoryPath", optional=true)
    public native boolean hasDirectoryPath();

    @Bridge(symbol="CFURLCopyResourceSpecifier", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getResourceSpecifier();

    @Bridge(symbol="CFURLCopyHostName", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getHostName();

    @Bridge(symbol="CFURLGetPortNumber", optional=true)
    public native int getPortNumber();

    @Bridge(symbol="CFURLCopyUserName", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getUserName();

    @Bridge(symbol="CFURLCopyPassword", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getPassword();

    @Deprecated
    @Bridge(symbol="CFURLCopyParameterString", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getParameterString(String var1);

    @Bridge(symbol="CFURLCopyQueryString", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getQueryString(String var1);

    @Bridge(symbol="CFURLCopyFragment", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getFragment(String var1);

    @Bridge(symbol="CFURLCopyLastPathComponent", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getLastPathComponent();

    @Bridge(symbol="CFURLCopyPathExtension", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getPathExtension();

    @Bridge(symbol="CFURLCreateCopyAppendingPathComponent", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFURL createCopyByAppendingPathComponent(CFAllocator var0, CFURL var1, String var2, boolean var3);

    @Bridge(symbol="CFURLCreateCopyDeletingLastPathComponent", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFURL createCopyByDeletingLastPathComponent(CFAllocator var0, CFURL var1);

    @Bridge(symbol="CFURLCreateCopyAppendingPathExtension", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFURL createCopyByAppendingPathExtension(CFAllocator var0, CFURL var1, String var2);

    @Bridge(symbol="CFURLCreateCopyDeletingPathExtension", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFURL createCopyByDeletingPathExtension(CFAllocator var0, CFURL var1);

    @Bridge(symbol="CFURLCreateStringByReplacingPercentEscapes", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public static native String decodeURLString(CFAllocator var0, String var1, String var2);

    @Deprecated
    @Bridge(symbol="CFURLCreateStringByReplacingPercentEscapesUsingEncoding", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public static native String decodeURLString(CFAllocator var0, String var1, String var2, CFStringEncodings var3);

    @Deprecated
    @Bridge(symbol="CFURLCreateStringByAddingPercentEscapes", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public static native String encodeURLString(CFAllocator var0, String var1, String var2, String var3, CFStringEncodings var4);

    @Bridge(symbol="CFURLIsFileReferenceURL", optional=true)
    public native boolean isFileReferenceURL();

    public static CFURL createFileReferenceURL(CFAllocator allocator, CFURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        CFURL result = CFURL.createFileReferenceURL(allocator, url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFURLCreateFileReferenceURL", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFURL createFileReferenceURL(CFAllocator var0, CFURL var1, NSError.NSErrorPtr var2);

    public static CFURL createFilePathURL(CFAllocator allocator, CFURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        CFURL result = CFURL.createFilePathURL(allocator, url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFURLCreateFilePathURL", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFURL createFilePathURL(CFAllocator var0, CFURL var1, NSError.NSErrorPtr var2);

    public boolean getResourceValue(String key, VoidPtr propertyValueTypeRefPtr) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.getResourceValue(key, propertyValueTypeRefPtr, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFURLCopyResourcePropertyForKey", optional=true)
    private native boolean getResourceValue(String var1, VoidPtr var2, NSError.NSErrorPtr var3);

    public CFDictionary getResourceValues(CFArray keys) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        CFDictionary result = this.getResourceValues(keys, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFURLCopyResourcePropertiesForKeys", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private native CFDictionary getResourceValues(CFArray var1, NSError.NSErrorPtr var2);

    public boolean setResourceValue(String key, CFType propertyValue) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setResourceValue(key, propertyValue, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFURLSetResourcePropertyForKey", optional=true)
    private native boolean setResourceValue(String var1, CFType var2, NSError.NSErrorPtr var3);

    public boolean setResourceValues(CFDictionary keyedPropertyValues) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setResourceValues(keyedPropertyValues, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFURLSetResourcePropertiesForKeys", optional=true)
    private native boolean setResourceValues(CFDictionary var1, NSError.NSErrorPtr var2);

    @Bridge(symbol="CFURLClearResourcePropertyCacheForKey", optional=true)
    public native void clearResourcePropertyCacheForKey(String var1);

    @Bridge(symbol="CFURLClearResourcePropertyCache", optional=true)
    public native void clearResourcePropertyCache();

    public boolean isResourceReachable() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.isResourceReachable(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFURLResourceIsReachable", optional=true)
    private native boolean isResourceReachable(NSError.NSErrorPtr var1);

    @Bridge(symbol="CFURLStartAccessingSecurityScopedResource", optional=true)
    public native boolean startAccessingSecurityScopedResource();

    @Bridge(symbol="CFURLStopAccessingSecurityScopedResource", optional=true)
    public native void stopAccessingSecurityScopedResource();

    @Bridge(symbol="CFCopyHomeDirectoryURL", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFURL getHomeDirectoryURL();

    static {
        Bro.bind(CFURL.class);
    }

    public static class CFURLPtr
    extends Ptr<CFURL, CFURLPtr> {
    }
}

