/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremedia;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.coremedia.CMTimeFlags;
import org.robovm.apple.coremedia.CMTimeMapping;
import org.robovm.apple.coremedia.CMTimeRange;
import org.robovm.apple.coremedia.CMTimeRoundingMethod;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSValue;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.annotation.Packed;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

@Packed(value=4)
@Library(value="CoreMedia")
public class CMTime
extends Struct<CMTime> {
    public static final long MaxTimescale = Integer.MAX_VALUE;

    public CMTime() {
    }

    public CMTime(long value, int timescale, CMTimeFlags flags, long epoch) {
        this.setValue(value);
        this.setTimescale(timescale);
        this.setFlags(flags);
        this.setEpoch(epoch);
    }

    @StructMember(value=0)
    public native long getValue();

    @StructMember(value=0)
    public native CMTime setValue(long var1);

    @StructMember(value=1)
    public native int getTimescale();

    @StructMember(value=1)
    public native CMTime setTimescale(int var1);

    @StructMember(value=2)
    public native CMTimeFlags getFlags();

    @StructMember(value=2)
    public native CMTime setFlags(CMTimeFlags var1);

    @StructMember(value=3)
    public native long getEpoch();

    @StructMember(value=3)
    public native CMTime setEpoch(long var1);

    public String toString() {
        return CMTime.getDescription(null, this);
    }

    @GlobalValue(symbol="kCMTimeInvalid", optional=true)
    @ByVal
    public static native CMTime Invalid();

    @GlobalValue(symbol="kCMTimeIndefinite", optional=true)
    @ByVal
    public static native CMTime Indefinite();

    @GlobalValue(symbol="kCMTimePositiveInfinity", optional=true)
    @ByVal
    public static native CMTime PositiveInfinity();

    @GlobalValue(symbol="kCMTimeNegativeInfinity", optional=true)
    @ByVal
    public static native CMTime NegativeInfinity();

    @GlobalValue(symbol="kCMTimeZero", optional=true)
    @ByVal
    public static native CMTime Zero();

    @GlobalValue(symbol="kCMTimeMappingInvalid", optional=true)
    @ByVal
    public static native CMTimeMapping MappingInvalid();

    @Bridge(symbol="CMTimeMake", optional=true)
    @ByVal
    public static native CMTime create(long var0, int var2);

    @Bridge(symbol="CMTimeMakeWithEpoch", optional=true)
    @ByVal
    public static native CMTime create(long var0, int var2, long var3);

    @Bridge(symbol="CMTimeMakeWithSeconds", optional=true)
    @ByVal
    public static native CMTime create(double var0, int var2);

    public double getSeconds() {
        return CMTime.getSeconds(this);
    }

    @Bridge(symbol="CMTimeGetSeconds", optional=true)
    private static native double getSeconds(@ByVal CMTime var0);

    public CMTime convertScale(int newTimescale, CMTimeRoundingMethod method) {
        return CMTime.convertScale(this, newTimescale, method);
    }

    @Bridge(symbol="CMTimeConvertScale", optional=true)
    @ByVal
    private static native CMTime convertScale(@ByVal CMTime var0, int var1, CMTimeRoundingMethod var2);

    public CMTime add(CMTime rhs) {
        return CMTime.add(this, rhs);
    }

    @Bridge(symbol="CMTimeAdd", optional=true)
    @ByVal
    private static native CMTime add(@ByVal CMTime var0, @ByVal CMTime var1);

    public CMTime subtract(CMTime rhs) {
        return CMTime.subtract(this, rhs);
    }

    @Bridge(symbol="CMTimeSubtract", optional=true)
    @ByVal
    private static native CMTime subtract(@ByVal CMTime var0, @ByVal CMTime var1);

    public CMTime multiply(int multiplier) {
        return CMTime.multiply(this, multiplier);
    }

    @Bridge(symbol="CMTimeMultiply", optional=true)
    @ByVal
    private static native CMTime multiply(@ByVal CMTime var0, int var1);

    public CMTime multiplyByFloat64(double multiplier) {
        return CMTime.multiplyByFloat64(this, multiplier);
    }

    @Bridge(symbol="CMTimeMultiplyByFloat64", optional=true)
    @ByVal
    private static native CMTime multiplyByFloat64(@ByVal CMTime var0, double var1);

    public CMTime multiplyByRatio(int multiplier, int divisor) {
        return CMTime.multiplyByRatio(this, multiplier, divisor);
    }

    @Bridge(symbol="CMTimeMultiplyByRatio", optional=true)
    @ByVal
    private static native CMTime multiplyByRatio(@ByVal CMTime var0, int var1, int var2);

    public int compare(CMTime time2) {
        return CMTime.compare(this, time2);
    }

    @Bridge(symbol="CMTimeCompare", optional=true)
    private static native int compare(@ByVal CMTime var0, @ByVal CMTime var1);

    public CMTime minimum(CMTime time2) {
        return CMTime.minimum(this, time2);
    }

    @Bridge(symbol="CMTimeMinimum", optional=true)
    @ByVal
    private static native CMTime minimum(@ByVal CMTime var0, @ByVal CMTime var1);

    public CMTime maximum(CMTime time2) {
        return CMTime.maximum(this, time2);
    }

    @Bridge(symbol="CMTimeMaximum", optional=true)
    @ByVal
    private static native CMTime maximum(@ByVal CMTime var0, @ByVal CMTime var1);

    public CMTime absoluteValue() {
        return CMTime.absoluteValue(this);
    }

    @Bridge(symbol="CMTimeAbsoluteValue", optional=true)
    @ByVal
    private static native CMTime absoluteValue(@ByVal CMTime var0);

    public NSDictionary asDictionary(CFAllocator allocator) {
        return CMTime.asDictionary(this, allocator);
    }

    @Bridge(symbol="CMTimeCopyAsDictionary", optional=true)
    private static native NSDictionary asDictionary(@ByVal CMTime var0, CFAllocator var1);

    @Bridge(symbol="CMTimeMakeFromDictionary", optional=true)
    @ByVal
    public static native CMTime create(NSDictionary var0);

    @Bridge(symbol="CMTimeCopyDescription", optional=true)
    private static native String getDescription(CFAllocator var0, @ByVal CMTime var1);

    public void show() {
        CMTime.show(this);
    }

    @Bridge(symbol="CMTimeShow", optional=true)
    private static native void show(@ByVal CMTime var0);

    public CMTime mapTimeFromRangeToRange(CMTimeRange fromRange, CMTimeRange toRange) {
        return CMTime.mapTimeFromRangeToRange(this, fromRange, toRange);
    }

    @Bridge(symbol="CMTimeMapTimeFromRangeToRange", optional=true)
    @ByVal
    private static native CMTime mapTimeFromRangeToRange(@ByVal CMTime var0, @ByVal CMTimeRange var1, @ByVal CMTimeRange var2);

    public CMTime clampToRange(CMTimeRange range) {
        return CMTime.clampToRange(this, range);
    }

    @Bridge(symbol="CMTimeClampToRange", optional=true)
    @ByVal
    private static native CMTime clampToRange(@ByVal CMTime var0, @ByVal CMTimeRange var1);

    public CMTime mapDurationFromRangeToRange(CMTimeRange fromRange, CMTimeRange toRange) {
        return CMTime.mapDurationFromRangeToRange(this, fromRange, toRange);
    }

    @Bridge(symbol="CMTimeMapDurationFromRangeToRange", optional=true)
    @ByVal
    private static native CMTime mapDurationFromRangeToRange(@ByVal CMTime var0, @ByVal CMTimeRange var1, @ByVal CMTimeRange var2);

    public CMTime foldIntoRange(CMTimeRange foldRange) {
        return CMTime.foldIntoRange(this, foldRange);
    }

    @Bridge(symbol="CMTimeFoldIntoRange", optional=true)
    @ByVal
    private static native CMTime foldIntoRange(@ByVal CMTime var0, @ByVal CMTimeRange var1);

    @Bridge(symbol="CMTimeMappingMake", optional=true)
    @ByVal
    public static native CMTimeMapping mappingMake(@ByVal CMTimeRange var0, @ByVal CMTimeRange var1);

    @Bridge(symbol="CMTimeMappingMakeEmpty", optional=true)
    @ByVal
    public static native CMTimeMapping mappingMakeEmpty(@ByVal CMTimeRange var0);

    @Bridge(symbol="CMTimeMappingCopyAsDictionary", optional=true)
    public static native NSDictionary mappingCopyAsDictionary(@ByVal CMTimeMapping var0, CFAllocator var1);

    @Bridge(symbol="CMTimeMappingMakeFromDictionary", optional=true)
    @ByVal
    public static native CMTimeMapping mappingMakeFromDictionary(NSDictionary var0);

    @Bridge(symbol="CMTimeMappingCopyDescription", optional=true)
    public static native String mappingCopyDescription(CFAllocator var0, @ByVal CMTimeMapping var1);

    @Bridge(symbol="CMTimeMappingShow", optional=true)
    public static native void mappingShow(@ByVal CMTimeMapping var0);

    static {
        Bro.bind(CMTime.class);
    }

    public static class CMTimePtr
    extends Ptr<CMTime, CMTimePtr> {
    }

    public static class AsValuedListMarshaler {
        @MarshalsPointer
        public static List<CMTime> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CMTime> list = new ArrayList<CMTime>();
            for (NSValue v : o) {
                list.add(v.timeValue());
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CMTime> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSValue> array = new NSMutableArray<NSValue>();
            for (CMTime i : l) {
                array.add(NSValue.valueOf(i));
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }
}

