/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremidi;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.coremidi.MIDIError;
import org.robovm.apple.coremidi.MIDINotification;
import org.robovm.apple.coremidi.MIDINotifyProc;
import org.robovm.apple.coremidi.MIDIObject;
import org.robovm.objc.LongMap;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreMIDI")
public class MIDIClient
extends MIDIObject {
    private static AtomicLong refconId = new AtomicLong();
    private static LongMap<MIDINotifyProc> notifyProcs = new LongMap();
    private static final Method cbNotifyProc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbNotifyProc(MIDINotification message, @Pointer long refCon) {
        MIDINotifyProc callback = null;
        LongMap<MIDINotifyProc> longMap = notifyProcs;
        synchronized (longMap) {
            callback = (MIDINotifyProc)notifyProcs.get(refCon);
        }
        callback.notify(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MIDIClient create(String name, MIDINotifyProc notifyProc) {
        MIDIClientPtr ptr;
        long refconId = MIDIClient.refconId.getAndIncrement();
        MIDIError err = MIDIClient.create(name, new FunctionPtr(cbNotifyProc), refconId, ptr = new MIDIClientPtr());
        if (err == MIDIError.No) {
            LongMap<MIDINotifyProc> longMap = notifyProcs;
            synchronized (longMap) {
                notifyProcs.put(refconId, (Object)notifyProc);
            }
            return (MIDIClient)ptr.get();
        }
        return null;
    }

    @Bridge(symbol="MIDIClientCreate", optional=true)
    protected static native MIDIError create(String var0, FunctionPtr var1, @Pointer long var2, MIDIClientPtr var4);

    @Bridge(symbol="MIDIClientCreateWithBlock", optional=true)
    protected static native MIDIError create(String var0, MIDIClientPtr var1, @Block VoidBlock1<MIDINotification> var2);

    @Bridge(symbol="MIDIClientDispose", optional=true)
    public native MIDIError dispose();

    static {
        try {
            cbNotifyProc = MIDIClient.class.getDeclaredMethod("cbNotifyProc", MIDINotification.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(MIDIClient.class);
    }

    public static class MIDIClientPtr
    extends Ptr<MIDIClient, MIDIClientPtr> {
    }
}

