/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreservices;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFData;
import org.robovm.apple.corefoundation.CFRunLoop;
import org.robovm.apple.corefoundation.CFRunLoopMode;
import org.robovm.apple.corefoundation.CFStreamError;
import org.robovm.apple.corefoundation.CFStreamErrorException;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coreservices.CFNetService;
import org.robovm.apple.coreservices.CFNetServiceClientContext;
import org.robovm.apple.coreservices.CFNetServiceMonitorType;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CFNetwork")
public class CFNetServiceMonitor
extends CFType {
    private static final AtomicLong refconId = new AtomicLong();
    private long localRefconId;
    private static final LongMap<ClientCallback> callbacks = new LongMap();
    private static final Method cbInvoke;

    protected CFNetServiceMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbInvoke(CFNetServiceMonitor monitor, CFNetService service, CFNetServiceMonitorType infoType, CFData data, CFStreamError.CFStreamErrorPtr error, @Pointer long refcon) {
        ClientCallback callback = null;
        LongMap<ClientCallback> longMap = callbacks;
        synchronized (longMap) {
            callback = (ClientCallback)callbacks.get(refcon);
        }
        CFStreamError err = null;
        if (error != null) {
            err = (CFStreamError)error.get();
        }
        callback.invoke(monitor, service, infoType, data, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFNetServiceMonitor create(CFNetService theService, ClientCallback clientCB) {
        long refconId = CFNetServiceMonitor.refconId.getAndIncrement();
        CFNetServiceClientContext context = new CFNetServiceClientContext();
        context.setInfo(refconId);
        LongMap<ClientCallback> longMap = callbacks;
        synchronized (longMap) {
            callbacks.put(refconId, (Object)clientCB);
        }
        CFNetServiceMonitor service = CFNetServiceMonitor.create(null, theService, new FunctionPtr(cbInvoke), context);
        if (service != null) {
            service.localRefconId = refconId;
        }
        return service;
    }

    public void scheduleInRunLoop(CFRunLoop runLoop, CFRunLoopMode runLoopMode) {
        this.scheduleInRunLoop(runLoop, ((CFString)runLoopMode.value()).toString());
    }

    public void unscheduleFromRunLoop(CFRunLoop runLoop, CFRunLoopMode runLoopMode) {
        this.unscheduleFromRunLoop(runLoop, ((CFString)runLoopMode.value()).toString());
    }

    @Deprecated
    @Bridge(symbol="CFNetServiceMonitorGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Deprecated
    @Bridge(symbol="CFNetServiceMonitorCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFNetServiceMonitor create(CFAllocator var0, CFNetService var1, FunctionPtr var2, CFNetServiceClientContext var3);

    @Deprecated
    @Bridge(symbol="CFNetServiceMonitorInvalidate", optional=true)
    public native void invalidate();

    @Deprecated
    public boolean start(CFNetServiceMonitorType recordType) throws CFStreamErrorException {
        CFStreamError.CFStreamErrorPtr ptr = new CFStreamError.CFStreamErrorPtr();
        boolean result = this.start(recordType, ptr);
        if (ptr.get() != null) {
            throw new CFStreamErrorException((CFStreamError)ptr.get());
        }
        return result;
    }

    @Deprecated
    @Bridge(symbol="CFNetServiceMonitorStart", optional=true)
    private native boolean start(CFNetServiceMonitorType var1, CFStreamError.CFStreamErrorPtr var2);

    @Deprecated
    public void stop() throws CFStreamErrorException {
        CFStreamError.CFStreamErrorPtr ptr = new CFStreamError.CFStreamErrorPtr();
        this.stop(ptr);
        if (ptr.get() != null) {
            throw new CFStreamErrorException((CFStreamError)ptr.get());
        }
    }

    @Deprecated
    @Bridge(symbol="CFNetServiceMonitorStop", optional=true)
    private native void stop(CFStreamError.CFStreamErrorPtr var1);

    @Deprecated
    @Bridge(symbol="CFNetServiceMonitorScheduleWithRunLoop", optional=true)
    public native void scheduleInRunLoop(CFRunLoop var1, String var2);

    @Deprecated
    @Bridge(symbol="CFNetServiceMonitorUnscheduleFromRunLoop", optional=true)
    public native void unscheduleFromRunLoop(CFRunLoop var1, String var2);

    static {
        try {
            cbInvoke = CFNetServiceMonitor.class.getDeclaredMethod("cbInvoke", CFNetServiceMonitor.class, CFNetService.class, CFNetServiceMonitorType.class, CFData.class, CFStreamError.CFStreamErrorPtr.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CFNetServiceMonitor.class);
    }

    public static interface ClientCallback {
        public void invoke(CFNetServiceMonitor var1, CFNetService var2, CFNetServiceMonitorType var3, CFData var4, CFStreamError var5);
    }

    public static class CFNetServiceMonitorPtr
    extends Ptr<CFNetServiceMonitor, CFNetServiceMonitorPtr> {
    }
}

