/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.List;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGContext;
import org.robovm.apple.coregraphics.CGPath;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coretext.CTFrameAttributes;
import org.robovm.apple.coretext.CTLine;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreText")
public class CTFrame
extends CFType {
    protected CTFrame() {
    }

    public CGPoint[] getLineOrigins(CFRange range) {
        int size;
        if (range == null) {
            throw new NullPointerException("range");
        }
        int n = size = range.getLength() == 0L ? this.getLines().size() : (int)range.getLength();
        if (size == 0) {
            return new CGPoint[0];
        }
        CGPoint array = (CGPoint)Struct.allocate(CGPoint.class, (int)size);
        this.getLineOrigins(range, array);
        return (CGPoint[])array.toArray(size);
    }

    @Bridge(symbol="CTFrameGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CTFrameGetStringRange", optional=true)
    @ByVal
    public native CFRange getStringRange();

    @Bridge(symbol="CTFrameGetVisibleStringRange", optional=true)
    @ByVal
    public native CFRange getVisibleStringRange();

    @Bridge(symbol="CTFrameGetPath", optional=true)
    public native CGPath getPath();

    @Bridge(symbol="CTFrameGetFrameAttributes", optional=true)
    public native CTFrameAttributes getFrameAttributes();

    @Bridge(symbol="CTFrameGetLines", optional=true)
    @Marshaler(value=CTLine.AsListMarshaler.class)
    public native List<CTLine> getLines();

    @Bridge(symbol="CTFrameGetLineOrigins", optional=true)
    protected native void getLineOrigins(@ByVal CFRange var1, CGPoint var2);

    @Bridge(symbol="CTFrameDraw", optional=true)
    public native void draw(CGContext var1);

    static {
        Bro.bind(CTFrame.class);
    }

    public static class CTFramePtr
    extends Ptr<CTFrame, CTFramePtr> {
    }
}

