/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corevideo;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreVideo")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CVPixelBufferPoolAttributes
extends CFDictionaryWrapper {
    CVPixelBufferPoolAttributes(CFDictionary data) {
        super(data);
    }

    public CVPixelBufferPoolAttributes() {
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public CVPixelBufferPoolAttributes set(CFString key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public int getMinimumBufferCount() {
        if (this.has(Keys.MinimumBufferCount())) {
            CFNumber val = this.get(Keys.MinimumBufferCount(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public CVPixelBufferPoolAttributes setMinimumBufferCount(int minimumBufferCount) {
        this.set(Keys.MinimumBufferCount(), CFNumber.valueOf(minimumBufferCount));
        return this;
    }

    public double getMaximumBufferAge() {
        if (this.has(Keys.MaximumBufferAge())) {
            CFNumber val = this.get(Keys.MaximumBufferAge(), CFNumber.class);
            return val.doubleValue();
        }
        return 0.0;
    }

    public CVPixelBufferPoolAttributes setMaximumBufferAge(double maximumBufferAge) {
        this.set(Keys.MaximumBufferAge(), CFNumber.valueOf(maximumBufferAge));
        return this;
    }

    @Library(value="CoreVideo")
    public static class Keys {
        @GlobalValue(symbol="kCVPixelBufferPoolMinimumBufferCountKey", optional=true)
        public static native CFString MinimumBufferCount();

        @GlobalValue(symbol="kCVPixelBufferPoolMaximumBufferAgeKey", optional=true)
        public static native CFString MaximumBufferAge();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CVPixelBufferPoolAttributes> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CVPixelBufferPoolAttributes> list = new ArrayList<CVPixelBufferPoolAttributes>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CVPixelBufferPoolAttributes(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CVPixelBufferPoolAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CVPixelBufferPoolAttributes i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CVPixelBufferPoolAttributes toObject(Class<CVPixelBufferPoolAttributes> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CVPixelBufferPoolAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(CVPixelBufferPoolAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

