/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.externalaccessory;

import org.robovm.apple.externalaccessory.EAAccessory;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSPredicate;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="ExternalAccessory")
@NativeClass
public class EAAccessoryManager
extends NSObject {
    public EAAccessoryManager() {
    }

    protected EAAccessoryManager(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected EAAccessoryManager(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="connectedAccessories")
    public native NSArray<EAAccessory> getConnectedAccessories();

    @GlobalValue(symbol="EAAccessoryDidConnectNotification", optional=true)
    public static native NSString AccessoryDidConnectNotification();

    @GlobalValue(symbol="EAAccessoryDidDisconnectNotification", optional=true)
    public static native NSString AccessoryDidDisconnectNotification();

    @GlobalValue(symbol="EAAccessoryKey", optional=true)
    protected static native NSString AccessoryKey();

    @GlobalValue(symbol="EAAccessorySelectedKey", optional=true)
    protected static native NSString AccessorySelectedKey();

    @Method(selector="showBluetoothAccessoryPickerWithNameFilter:completion:")
    public native void showBluetoothAccessoryPicker(NSPredicate var1, @Block VoidBlock1<NSError> var2);

    @Method(selector="registerForLocalNotifications")
    public native void registerForLocalNotifications();

    @Method(selector="unregisterForLocalNotifications")
    public native void unregisterForLocalNotifications();

    @Method(selector="sharedAccessoryManager")
    public static native EAAccessoryManager getSharedAccessoryManager();

    static {
        ObjCRuntime.bind(EAAccessoryManager.class);
    }

    public static class EAAccessoryManagerPtr
    extends Ptr<EAAccessoryManager, EAAccessoryManagerPtr> {
    }

    public static class Notifications {
        public static NSObjectProtocol observeAccessoryDidConnect(EAAccessoryManager object, final VoidBlock3<EAAccessoryManager, EAAccessory, EAAccessory> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(EAAccessoryManager.AccessoryDidConnectNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<?, ?> data = a.getUserInfo();
                    EAAccessory accessory = null;
                    EAAccessory selectedAccessory = null;
                    if (data.containsKey(EAAccessoryManager.AccessoryKey())) {
                        accessory = (EAAccessory)data.get(EAAccessoryManager.AccessoryKey());
                    }
                    if (data.containsKey(EAAccessoryManager.AccessorySelectedKey())) {
                        selectedAccessory = (EAAccessory)data.get(EAAccessoryManager.AccessorySelectedKey());
                    }
                    block.invoke((Object)((EAAccessoryManager)a.getObject()), (Object)accessory, (Object)selectedAccessory);
                }
            });
        }

        public static NSObjectProtocol observeAccessoryDidDisconnect(EAAccessoryManager object, final VoidBlock2<EAAccessoryManager, EAAccessory> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(EAAccessoryManager.AccessoryDidDisconnectNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<?, ?> data = a.getUserInfo();
                    EAAccessory accessory = null;
                    if (data.containsKey(EAAccessoryManager.AccessoryKey())) {
                        accessory = (EAAccessory)data.get(EAAccessoryManager.AccessoryKey());
                    }
                    block.invoke((Object)((EAAccessoryManager)a.getObject()), (Object)accessory);
                }
            });
        }
    }
}

