/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSComparisonResult;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.uikit.NSIndexPathExtensions;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.MachineSizedUIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSIndexPath
extends NSObject
implements NSSecureCoding {
    public NSIndexPath() {
    }

    protected NSIndexPath(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSIndexPath(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithIndex:")
    public NSIndexPath(@MachineSizedUInt long index) {
        super(null);
        this.initObject(this.init(index));
    }

    @Method(selector="initWithCoder:")
    public NSIndexPath(NSCoder coder) {
        super(null);
        this.initObject(this.init(coder));
    }

    public NSIndexPath(long[] indexes) {
        super(null);
        if (indexes == null) {
            throw new NullPointerException("indexes");
        }
        MachineSizedUIntPtr p = (MachineSizedUIntPtr)Struct.allocate(MachineSizedUIntPtr.class, (int)indexes.length);
        p.set(indexes);
        this.initObject(this.init(p, indexes.length));
    }

    @Property(selector="length")
    @MachineSizedUInt
    public native long getLength();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    public int[] getIndexes() {
        int n = (int)this.getLength();
        MachineSizedUIntPtr p = (MachineSizedUIntPtr)Struct.allocate(MachineSizedUIntPtr.class, (int)n);
        this.getIndexes(p);
        return p.toIntArray(n);
    }

    public int[] getIndexes(NSRange positionRange) {
        int n = (int)this.getLength();
        MachineSizedUIntPtr p = (MachineSizedUIntPtr)Struct.allocate(MachineSizedUIntPtr.class, (int)((int)positionRange.getLength()));
        this.getIndexes(p, positionRange);
        return p.toIntArray(n);
    }

    @WeaklyLinked
    public int getSection() {
        return (int)NSIndexPathExtensions.getSection(this);
    }

    @WeaklyLinked
    public int getRow() {
        return (int)NSIndexPathExtensions.getRow(this);
    }

    @WeaklyLinked
    public int getItem() {
        return (int)NSIndexPathExtensions.getItem(this);
    }

    @WeaklyLinked
    public static NSIndexPath row(@MachineSizedSInt long row, @MachineSizedSInt long section) {
        return NSIndexPathExtensions.createIndexPathForRowInSection(row, section);
    }

    @WeaklyLinked
    public static NSIndexPath item(@MachineSizedSInt long item, @MachineSizedSInt long section) {
        return NSIndexPathExtensions.createIndexPathForItemInSection(item, section);
    }

    @Method(selector="initWithIndexes:length:")
    @Pointer
    private native long init(MachineSizedUIntPtr var1, @MachineSizedUInt long var2);

    @Method(selector="initWithIndex:")
    @Pointer
    protected native long init(@MachineSizedUInt long var1);

    @Method(selector="indexPathByAddingIndex:")
    public native NSIndexPath addIndex(@MachineSizedUInt long var1);

    @Method(selector="indexPathByRemovingLastIndex")
    public native NSIndexPath removeLastIndex();

    @Method(selector="indexAtPosition:")
    @MachineSizedUInt
    public native long getIndexAt(@MachineSizedUInt long var1);

    @Method(selector="getIndexes:range:")
    private native void getIndexes(MachineSizedUIntPtr var1, @ByVal NSRange var2);

    @Method(selector="compare:")
    public native NSComparisonResult compare(NSIndexPath var1);

    @Deprecated
    @Method(selector="getIndexes:")
    private native void getIndexes(MachineSizedUIntPtr var1);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(NSIndexPath.class);
    }

    public static class NSIndexPathPtr
    extends Ptr<NSIndexPath, NSIndexPathPtr> {
    }
}

