/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSRunLoopMode;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSUndoManager
extends NSObject {
    public static final int CloseGroupingRunLoopOrdering = 350000;

    public NSUndoManager() {
    }

    protected NSUndoManager(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSUndoManager(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public void setRunLoopModes(NSRunLoopMode ... modes) {
        ArrayList<String> list = new ArrayList<String>();
        for (NSRunLoopMode mode : modes) {
            list.add(((NSString)mode.value()).toString());
        }
        this.setRunLoopModes(list);
    }

    @Property(selector="groupingLevel")
    @MachineSizedSInt
    public native long getGroupingLevel();

    @Property(selector="isUndoRegistrationEnabled")
    public native boolean isUndoRegistrationEnabled();

    @Property(selector="groupsByEvent")
    public native boolean groupsByEvent();

    @Property(selector="setGroupsByEvent:")
    public native void setGroupsByEvent(boolean var1);

    @Property(selector="levelsOfUndo")
    @MachineSizedUInt
    public native long getLevelsOfUndo();

    @Property(selector="setLevelsOfUndo:")
    public native void setLevelsOfUndo(@MachineSizedUInt long var1);

    @Property(selector="runLoopModes")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getRunLoopModes();

    @Property(selector="setRunLoopModes:")
    public native void setRunLoopModes(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Property(selector="canUndo")
    public native boolean canUndo();

    @Property(selector="canRedo")
    public native boolean canRedo();

    @Property(selector="isUndoing")
    public native boolean isUndoing();

    @Property(selector="isRedoing")
    public native boolean isRedoing();

    @Property(selector="undoActionIsDiscardable")
    public native boolean isUndoActionDiscardable();

    @Property(selector="redoActionIsDiscardable")
    public native boolean isRedoActionDiscardable();

    @Property(selector="undoActionName")
    public native String getUndoActionName();

    @Property(selector="redoActionName")
    public native String getRedoActionName();

    @Property(selector="undoMenuItemTitle")
    public native String getUndoMenuItemTitle();

    @Property(selector="redoMenuItemTitle")
    public native String getRedoMenuItemTitle();

    @GlobalValue(symbol="NSUndoManagerGroupIsDiscardableKey", optional=true)
    protected static native NSString GroupIsDiscardableKey();

    @GlobalValue(symbol="NSUndoManagerCheckpointNotification", optional=true)
    public static native NSString CheckpointNotification();

    @GlobalValue(symbol="NSUndoManagerWillUndoChangeNotification", optional=true)
    public static native NSString WillUndoChangeNotification();

    @GlobalValue(symbol="NSUndoManagerWillRedoChangeNotification", optional=true)
    public static native NSString WillRedoChangeNotification();

    @GlobalValue(symbol="NSUndoManagerDidUndoChangeNotification", optional=true)
    public static native NSString DidUndoChangeNotification();

    @GlobalValue(symbol="NSUndoManagerDidRedoChangeNotification", optional=true)
    public static native NSString DidRedoChangeNotification();

    @GlobalValue(symbol="NSUndoManagerDidOpenUndoGroupNotification", optional=true)
    public static native NSString DidOpenUndoGroupNotification();

    @GlobalValue(symbol="NSUndoManagerWillCloseUndoGroupNotification", optional=true)
    public static native NSString WillCloseUndoGroupNotification();

    @GlobalValue(symbol="NSUndoManagerDidCloseUndoGroupNotification", optional=true)
    public static native NSString DidCloseUndoGroupNotification();

    @Method(selector="beginUndoGrouping")
    public native void beginUndoGrouping();

    @Method(selector="endUndoGrouping")
    public native void endUndoGrouping();

    @Method(selector="disableUndoRegistration")
    public native void disableUndoRegistration();

    @Method(selector="enableUndoRegistration")
    public native void enableUndoRegistration();

    @Method(selector="undo")
    public native void undo();

    @Method(selector="redo")
    public native void redo();

    @Method(selector="undoNestedGroup")
    public native void undoNestedGroup();

    @Method(selector="removeAllActions")
    public native void removeAllActions();

    @Method(selector="removeAllActionsWithTarget:")
    public native void removeAllActions(NSObject var1);

    @Method(selector="registerUndoWithTarget:selector:object:")
    public native void registerUndo(NSObject var1, Selector var2, NSObject var3);

    @Method(selector="prepareWithInvocationTarget:")
    public native NSObject prepareWithInvocation(NSObject var1);

    @Method(selector="registerUndoWithTarget:handler:")
    public native void registerUndo(NSObject var1, @Block VoidBlock1<NSObject> var2);

    @Method(selector="setActionIsDiscardable:")
    public native void setActionIsDiscardable(boolean var1);

    @Method(selector="setActionName:")
    public native void setActionName(String var1);

    @Method(selector="undoMenuTitleForUndoActionName:")
    public native String getUndoMenuTitle(String var1);

    @Method(selector="redoMenuTitleForUndoActionName:")
    public native String getRedoMenuTitle(String var1);

    static {
        ObjCRuntime.bind(NSUndoManager.class);
    }

    public static class NSUndoManagerPtr
    extends Ptr<NSUndoManager, NSUndoManagerPtr> {
    }

    public static class Notifications {
        public static NSObjectProtocol observeCheckpoint(NSUndoManager object, final VoidBlock1<NSUndoManager> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSUndoManager.CheckpointNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSUndoManager)a.getObject()));
                }
            });
        }

        public static NSObjectProtocol observeWillUndoChange(NSUndoManager object, final VoidBlock1<NSUndoManager> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSUndoManager.WillUndoChangeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSUndoManager)a.getObject()));
                }
            });
        }

        public static NSObjectProtocol observeWillRedoChange(NSUndoManager object, final VoidBlock1<NSUndoManager> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSUndoManager.WillRedoChangeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSUndoManager)a.getObject()));
                }
            });
        }

        public static NSObjectProtocol observeDidUndoChange(NSUndoManager object, final VoidBlock1<NSUndoManager> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSUndoManager.DidUndoChangeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSUndoManager)a.getObject()));
                }
            });
        }

        public static NSObjectProtocol observeDidRedoChange(NSUndoManager object, final VoidBlock1<NSUndoManager> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSUndoManager.DidRedoChangeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSUndoManager)a.getObject()));
                }
            });
        }

        public static NSObjectProtocol observeDidOpenUndoGroup(NSUndoManager object, final VoidBlock1<NSUndoManager> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSUndoManager.DidOpenUndoGroupNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSUndoManager)a.getObject()));
                }
            });
        }

        public static NSObjectProtocol observeWillCloseUndoGroup(NSUndoManager object, final VoidBlock2<NSUndoManager, Boolean> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSUndoManager.WillCloseUndoGroupNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    boolean b = false;
                    NSDictionary<?, ?> data = a.getUserInfo();
                    if (data.containsKey(NSUndoManager.GroupIsDiscardableKey())) {
                        NSNumber val = (NSNumber)data.get(NSUndoManager.GroupIsDiscardableKey());
                        b = val.booleanValue();
                    }
                    block.invoke((Object)((NSUndoManager)a.getObject()), (Object)b);
                }
            });
        }

        public static NSObjectProtocol observeDidCloseUndoGroup(NSUndoManager object, final VoidBlock1<NSUndoManager> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSUndoManager.DidCloseUndoGroupNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSUndoManager)a.getObject()));
                }
            });
        }
    }
}

