/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSAttributedString;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.UIAccessibilityGlobals;
import org.robovm.apple.uikit.UIAccessibilityNavigationStyle;
import org.robovm.apple.uikit.UIAccessibilityTraits;
import org.robovm.apple.uikit.UIBezierPath;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.ByVal;

public interface UIAccessibility
extends NSObjectProtocol {
    @Property(selector="isAccessibilityElement")
    public boolean isAccessibilityElement();

    @Property(selector="setIsAccessibilityElement:")
    public void setAccessibilityElement(boolean var1);

    @Property(selector="accessibilityLabel")
    public String getAccessibilityLabel();

    @Property(selector="setAccessibilityLabel:")
    public void setAccessibilityLabel(String var1);

    @Property(selector="accessibilityAttributedLabel")
    public NSAttributedString getAccessibilityAttributedLabel();

    @Property(selector="setAccessibilityAttributedLabel:")
    public void setAccessibilityAttributedLabel(NSAttributedString var1);

    @Property(selector="accessibilityHint")
    public String getAccessibilityHint();

    @Property(selector="setAccessibilityHint:")
    public void setAccessibilityHint(String var1);

    @Property(selector="accessibilityAttributedHint")
    public NSAttributedString getAccessibilityAttributedHint();

    @Property(selector="setAccessibilityAttributedHint:")
    public void setAccessibilityAttributedHint(NSAttributedString var1);

    @Property(selector="accessibilityValue")
    public String getAccessibilityValue();

    @Property(selector="setAccessibilityValue:")
    public void setAccessibilityValue(String var1);

    @Property(selector="accessibilityAttributedValue")
    public NSAttributedString getAccessibilityAttributedValue();

    @Property(selector="setAccessibilityAttributedValue:")
    public void setAccessibilityAttributedValue(NSAttributedString var1);

    @Property(selector="accessibilityTraits")
    public UIAccessibilityTraits getAccessibilityTraits();

    @Property(selector="setAccessibilityTraits:")
    public void setAccessibilityTraits(UIAccessibilityTraits var1);

    @Property(selector="accessibilityFrame")
    @ByVal
    public CGRect getAccessibilityFrame();

    @Property(selector="setAccessibilityFrame:")
    public void setAccessibilityFrame(@ByVal CGRect var1);

    @Property(selector="accessibilityPath")
    public UIBezierPath getAccessibilityPath();

    @Property(selector="setAccessibilityPath:")
    public void setAccessibilityPath(UIBezierPath var1);

    @Property(selector="accessibilityActivationPoint")
    @ByVal
    public CGPoint getAccessibilityActivationPoint();

    @Property(selector="setAccessibilityActivationPoint:")
    public void setAccessibilityActivationPoint(@ByVal CGPoint var1);

    @Property(selector="accessibilityLanguage")
    public String getAccessibilityLanguage();

    @Property(selector="setAccessibilityLanguage:")
    public void setAccessibilityLanguage(String var1);

    @Property(selector="accessibilityElementsHidden")
    public boolean areAccessibilityElementsHidden();

    @Property(selector="setAccessibilityElementsHidden:")
    public void setAccessibilityElementsHidden(boolean var1);

    @Property(selector="accessibilityViewIsModal")
    public boolean isAccessibilityViewModal();

    @Property(selector="setAccessibilityViewIsModal:")
    public void setAccessibilityViewModal(boolean var1);

    @Property(selector="shouldGroupAccessibilityChildren")
    public boolean shouldGroupAccessibilityChildren();

    @Property(selector="setShouldGroupAccessibilityChildren:")
    public void setShouldGroupAccessibilityChildren(boolean var1);

    @Property(selector="accessibilityNavigationStyle")
    public UIAccessibilityNavigationStyle getAccessibilityNavigationStyle();

    @Property(selector="setAccessibilityNavigationStyle:")
    public void setAccessibilityNavigationStyle(UIAccessibilityNavigationStyle var1);

    @Property(selector="accessibilityRespondsToUserInteraction")
    public boolean isAccessibilityRespondsToUserInteraction();

    @Property(selector="setAccessibilityRespondsToUserInteraction:")
    public void setAccessibilityRespondsToUserInteraction(boolean var1);

    @Property(selector="accessibilityUserInputLabels")
    public NSArray<NSString> getAccessibilityUserInputLabels();

    @Property(selector="setAccessibilityUserInputLabels:")
    public void setAccessibilityUserInputLabels(NSArray<NSString> var1);

    @Property(selector="accessibilityAttributedUserInputLabels")
    public NSArray<NSAttributedString> getAccessibilityAttributedUserInputLabels();

    @Property(selector="setAccessibilityAttributedUserInputLabels:")
    public void setAccessibilityAttributedUserInputLabels(NSArray<NSAttributedString> var1);

    @Property(selector="accessibilityTextualContext")
    public String getAccessibilityTextualContext();

    @Property(selector="setAccessibilityTextualContext:")
    public void setAccessibilityTextualContext(String var1);

    public static class Notifications {
        public static NSObjectProtocol observeElementFocused(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.ElementFocusedNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeAnnouncementDidFinish(final VoidBlock2<String, Boolean> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.AnnouncementDidFinishNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<?, ?> data = a.getUserInfo();
                    NSString string = (NSString)data.get(UIAccessibilityGlobals.AnnouncementKeyStringValue());
                    NSNumber successful = (NSNumber)data.get(UIAccessibilityGlobals.AnnouncementKeyWasSuccessful());
                    block.invoke((Object)string.toString(), (Object)successful.booleanValue());
                }
            });
        }

        public static NSObjectProtocol observeMonoAudioStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.MonoAudioStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeClosedCaptioningStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.ClosedCaptioningStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeInvertColorsStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.InvertColorsStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeGuidedAccessStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.GuidedAccessStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeVoiceOverStatusChanged(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.VoiceOverStatusChangedNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeBoldTextStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.BoldTextStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeGrayscaleStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.GrayscaleStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeReduceTransparencyStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.ReduceTransparencyStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeReduceMotionStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.ReduceMotionStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeDarkerSystemColorsStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.DarkerSystemColorsStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeSwitchControlStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.SwitchControlStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeSpeakSelectionStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.SpeakSelectionStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeSpeakScreenStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.SpeakScreenStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObjectProtocol observeShakeToUndoDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIAccessibilityGlobals.ShakeToUndoDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

