/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.addressbook;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corefoundation.*;
/*</imports>*/

/*<javadoc>*/
/*</javadoc>*/
@StronglyLinked
/*<annotations>*/@Library("AddressBook")/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/ABPropertyLabel/*</name>*/ 
    extends /*<extends>*/CocoaUtility/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/
    /*</ptr>*/
    /*<bind>*/static { Bro.bind(ABPropertyLabel.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    public static final ABPropertyLabel Work = new ABPropertyLabel("WorkLabel");
    public static final ABPropertyLabel Home = new ABPropertyLabel("HomeLabel");
    public static final ABPropertyLabel Other = new ABPropertyLabel("OtherLabel");
    private static ABPropertyLabel[] values = new ABPropertyLabel[] {Work, Home, Other};
    
    private final LazyGlobalValue<CFString> lazyGlobalValue;
    
    protected ABPropertyLabel(String getterName) {
        lazyGlobalValue = new LazyGlobalValue<>(getClass(), getterName);
    }
    /*<constructors>*//*</constructors>*/
    /*<properties>*//*</properties>*/
    /*<members>*//*</members>*/
    public CFString value() {
        return lazyGlobalValue.value();
    }
    
    public static ABPropertyLabel valueOf(CFString value) {
        for (ABPropertyLabel v : values) {
            if (v.value().equals(value)) {
                return v;
            }
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " 
            + /*<name>*/ABPropertyLabel/*</name>*/.class.getName());
    }
    /*<methods>*/
    /**
     * @deprecated Deprecated in iOS 9.0. use CNLabelWork
     */
    @Deprecated
    @GlobalValue(symbol="kABWorkLabel", optional=true)
    protected static native CFString WorkLabel();
    /**
     * @deprecated Deprecated in iOS 9.0. use CNLabelHome
     */
    @Deprecated
    @GlobalValue(symbol="kABHomeLabel", optional=true)
    protected static native CFString HomeLabel();
    /**
     * @deprecated Deprecated in iOS 9.0. use CNLabelOther
     */
    @Deprecated
    @GlobalValue(symbol="kABOtherLabel", optional=true)
    protected static native CFString OtherLabel();
    /*</methods>*/
}
