/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.automaticac;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 13.4 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("AutomaticAssessmentConfiguration") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/AEAssessmentSession/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class AEAssessmentSessionPtr extends Ptr<AEAssessmentSession, AEAssessmentSessionPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(AEAssessmentSession.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    protected AEAssessmentSession() {}
    protected AEAssessmentSession(Handle h, long handle) { super(h, handle); }
    protected AEAssessmentSession(SkipInit skipInit) { super(skipInit); }
    @Method(selector = "initWithConfiguration:")
    public AEAssessmentSession(AEAssessmentConfiguration configuration) { super((SkipInit) null); initObject(init(configuration)); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "delegate")
    public native AEAssessmentSessionDelegate getDelegate();
    @Property(selector = "setDelegate:", strongRef = true)
    public native void setDelegate(AEAssessmentSessionDelegate v);
    /**
     * @since Available in iOS 15.0 and later.
     */
    @Property(selector = "configuration")
    public native AEAssessmentConfiguration getConfiguration();
    @Property(selector = "isActive")
    public native boolean isActive();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    @Method(selector = "initWithConfiguration:")
    protected native @Pointer long init(AEAssessmentConfiguration configuration);
    @Method(selector = "begin")
    public native void begin();
    @Method(selector = "end")
    public native void end();
    /*</methods>*/
}
