/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.avfoundation;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corefoundation.*;
import org.robovm.apple.dispatch.*;
import org.robovm.apple.coreanimation.*;
import org.robovm.apple.coreimage.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.coreaudio.*;
import org.robovm.apple.coremedia.*;
import org.robovm.apple.corevideo.*;
import org.robovm.apple.mediatoolbox.*;
import org.robovm.apple.audiotoolbox.*;
/*</imports>*/

/*<javadoc>*/
/*</javadoc>*/
/*<annotations>*/@Library("AVFoundation")/*</annotations>*/
@Marshaler(/*<name>*/AVMetadataExtraAttributes/*</name>*/.Marshaler.class)
/*<visibility>*/public/*</visibility>*/ class /*<name>*/AVMetadataExtraAttributes/*</name>*/ 
    extends /*<extends>*/NSDictionaryWrapper/*</extends>*/
    /*<implements>*//*</implements>*/ {

    /*<marshalers>*/
    public static class Marshaler {
        @MarshalsPointer
        public static AVMetadataExtraAttributes toObject(Class<AVMetadataExtraAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary) NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVMetadataExtraAttributes(o);
        }
        @MarshalsPointer
        public static long toNative(AVMetadataExtraAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVMetadataExtraAttributes> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray<NSDictionary> o = (NSArray<NSDictionary>) NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            List<AVMetadataExtraAttributes> list = new ArrayList<>();
            for (int i = 0; i < o.size(); i++) {
                list.add(new AVMetadataExtraAttributes(o.get(i)));
            }
            return list;
        }
        @MarshalsPointer
        public static long toNative(List<AVMetadataExtraAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSArray<NSDictionary> array = new NSMutableArray<>();
            for (AVMetadataExtraAttributes i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }
    /*</marshalers>*/

    /*<constructors>*/
    AVMetadataExtraAttributes(NSDictionary data) {
        super(data);
    }
    public AVMetadataExtraAttributes() {}
    /*</constructors>*/

    /*<methods>*/
    public boolean has(NSString key) {
        return data.containsKey(key);
    }
    public NSObject get(NSString key) {
        if (has(key)) {
            return data.get(key);
        }
        return null;
    }
    public AVMetadataExtraAttributes set(NSString key, NSObject value) {
        data.put(key, value);
        return this;
    }
    

    public String getValueURI() {
        if (has(Keys.ValueURI())) {
            NSString val = (NSString) get(Keys.ValueURI());
            return val.toString();
        }
        return null;
    }
    public AVMetadataExtraAttributes setValueURI(String valueURI) {
        set(Keys.ValueURI(), new NSString(valueURI));
        return this;
    }
    public String getBaseURI() {
        if (has(Keys.BaseURI())) {
            NSString val = (NSString) get(Keys.BaseURI());
            return val.toString();
        }
        return null;
    }
    public AVMetadataExtraAttributes setBaseURI(String baseURI) {
        set(Keys.BaseURI(), new NSString(baseURI));
        return this;
    }
    /**
     * @since Available in iOS 9.0 and later.
     */
    public String getInfo() {
        if (has(Keys.Info())) {
            NSString val = (NSString) get(Keys.Info());
            return val.toString();
        }
        return null;
    }
    /**
     * @since Available in iOS 9.0 and later.
     */
    public AVMetadataExtraAttributes setInfo(String info) {
        set(Keys.Info(), new NSString(info));
        return this;
    }
    /*</methods>*/
    
    /*<keys>*/
    @Library("AVFoundation")
    public static class Keys {
        static { Bro.bind(Keys.class); }
        @GlobalValue(symbol="AVMetadataExtraAttributeValueURIKey", optional=true)
        public static native NSString ValueURI();
        @GlobalValue(symbol="AVMetadataExtraAttributeBaseURIKey", optional=true)
        public static native NSString BaseURI();
        /**
         * @since Available in iOS 9.0 and later.
         */
        @GlobalValue(symbol="AVMetadataExtraAttributeInfoKey", optional=true)
        public static native NSString Info();
    }
    /*</keys>*/
}
